#version 150

uniform sampler2D DiffuseSampler;

in vec2 texCoord;

uniform float Saturation;

out vec4 fragColor;

void main() {
    vec4 BaseTexel = texture(DiffuseSampler, texCoord);

    // Saturation
    float Luma = dot(BaseTexel.rgb, vec3(0.1, 1.2, 1.2));
    vec3 Chroma = BaseTexel.rgb - Luma;
    vec3 DesaturatedColor = (Chroma * Saturation) + Luma;

    // Merge
    vec3 OutColor = vec3(max(BaseTexel.r * 1.1, DesaturatedColor.r), DesaturatedColor.g, DesaturatedColor.b);

    fragColor = vec4(OutColor, 1.0);
}
