/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class TickingData
extends SavedData {
    public static final SavedData.Factory<TickingData> FACTORY = new SavedData.Factory(TickingData::new, TickingData::load, null);
    private final Object2IntMap<UUID> tickMap = new Object2IntOpenHashMap();

    public TickingData() {
        this.tickMap.defaultReturnValue(-1);
    }

    public static TickingData load(CompoundTag pCompound, HolderLookup.Provider provider) {
        TickingData data = new TickingData();
        data.tickMap.clear();
        data.tickMap.defaultReturnValue(-1);
        ListTag decayList = pCompound.getList("result", 10);
        for (int i = 0; i < decayList.size(); ++i) {
            CompoundTag thisTag = decayList.getCompound(i);
            data.tickMap.put((Object)thisTag.getUUID("id"), thisTag.getInt("value"));
        }
        return data;
    }

    public boolean isComplete(UUID id) {
        return this.tickMap.getInt((Object)id) == 0 || this.tickMap.getInt((Object)id) == 1;
    }

    public int getValue(UUID id) {
        return this.tickMap.getInt((Object)id);
    }

    public void setValue(UUID id, int decayAmount) {
        if (this.tickMap.put((Object)id, decayAmount) == -1) {
            this.setDirty();
        }
    }

    public void remove(UUID id) {
        if (this.tickMap.removeInt((Object)id) != -1) {
            this.setDirty();
        }
    }

    public void tick() {
        if (this.tickMap.isEmpty()) {
            return;
        }
        Object2IntOpenHashMap newMap = new Object2IntOpenHashMap();
        newMap.defaultReturnValue(-1);
        boolean changed = false;
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            int value = entry.getIntValue();
            if (value > 0) {
                --value;
                changed = true;
            }
            newMap.put((Object)((UUID)entry.getKey()), value);
        }
        if (changed) {
            this.tickMap.clear();
            this.tickMap.putAll((Map)newMap);
            this.setDirty();
        }
    }

    public CompoundTag save(CompoundTag pCompound, HolderLookup.Provider provider) {
        ListTag decayList = new ListTag();
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            CompoundTag thisTag = new CompoundTag();
            thisTag.putUUID("id", (UUID)entry.getKey());
            thisTag.putInt("value", entry.getIntValue());
            decayList.add((Object)thisTag);
        }
        pCompound.put("result", (Tag)decayList);
        return pCompound;
    }
}

