/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.init.ModSoundEvents;
import fuzs.illagerinvasion.util.SetMagicFireUtil;
import fuzs.illagerinvasion.util.TeleportUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;

public class Sorcerer
extends SpellcasterIllager {
    private int castTeleportCooldown;
    private int conjureFlamesCooldown;

    public Sorcerer(EntityType<? extends Sorcerer> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtTargetOrWololoTarget());
        this.goalSelector.addGoal(4, (Goal)new CastTeleportGoal());
        this.goalSelector.addGoal(3, (Goal)new ConjureFlamesGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSoundEvents.SORCERER_CELEBRATE_SOUND_EVENT.value();
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        --this.castTeleportCooldown;
        --this.conjureFlamesCooldown;
    }

    public boolean isAlliedTo(Entity other) {
        LivingEntity livingEntity;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.isAlliedTo(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.isAlliedTo((Entity)((Vex)other).getOwner());
        }
        if (other instanceof LivingEntity && (livingEntity = (LivingEntity)other).getType().is(EntityTypeTags.ILLAGER_FRIENDS)) {
            return this.getTeam() == null && other.getTeam() == null;
        }
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.SORCERER_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.SORCERER_DEATH_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSoundEvents.SORCERER_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)ModSoundEvents.SORCERER_COMPLETE_CAST_SOUND_EVENT.value();
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Sorcerer.this);
        }

        public void tick() {
            if (Sorcerer.this.getTarget() != null) {
                Sorcerer.this.getLookControl().setLookAt((Entity)Sorcerer.this.getTarget(), (float)Sorcerer.this.getMaxHeadYRot(), (float)Sorcerer.this.getMaxHeadXRot());
            }
        }
    }

    public class CastTeleportGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public CastTeleportGoal() {
            super((SpellcasterIllager)Sorcerer.this);
        }

        public boolean canUse() {
            if (Sorcerer.this.getTarget() == null) {
                return false;
            }
            if (Sorcerer.this.isCastingSpell()) {
                return false;
            }
            return Sorcerer.this.castTeleportCooldown < 0 && !this.getTargets().isEmpty();
        }

        private List<LivingEntity> getTargets() {
            return Sorcerer.this.level().getEntitiesOfClass(LivingEntity.class, Sorcerer.this.getBoundingBox().inflate(8.0), entity -> entity instanceof Player || entity instanceof IronGolem);
        }

        public boolean canContinueToUse() {
            return !this.getTargets().isEmpty();
        }

        protected void performSpellCasting() {
            Sorcerer.this.castTeleportCooldown = 220;
            double x = Sorcerer.this.getX();
            double y = Sorcerer.this.getY() + 1.0;
            double z = Sorcerer.this.getZ();
            if (Sorcerer.this.level() instanceof ServerLevel) {
                ((ServerLevel)Sorcerer.this.level()).sendParticles((ParticleOptions)ParticleTypes.WITCH, x, y, z, 30, 0.3, 0.5, 0.3, 0.015);
            }
            TeleportUtil.tryRandomTeleport((LivingEntity)Sorcerer.this);
        }

        protected int getCastWarmupTime() {
            return 30;
        }

        protected int getCastingTime() {
            return 30;
        }

        protected int getCastingInterval() {
            return 400;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.SORCERER_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return ModRegistry.CONJURE_TELEPORT_ILLAGER_SPELL;
        }
    }

    public class ConjureFlamesGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public ConjureFlamesGoal() {
            super((SpellcasterIllager)Sorcerer.this);
        }

        public boolean canUse() {
            if (Sorcerer.this.getTarget() == null) {
                return false;
            }
            if (Sorcerer.this.isCastingSpell()) {
                return false;
            }
            return Sorcerer.this.conjureFlamesCooldown < 0;
        }

        protected void performSpellCasting() {
            LivingEntity target = Sorcerer.this.getTarget();
            SetMagicFireUtil.trySetFire(target, Sorcerer.this.level());
            Sorcerer.this.conjureFlamesCooldown = 100;
            target.hurt(Sorcerer.this.damageSources().magic(), 3.0f);
            if (Sorcerer.this.level() instanceof ServerLevel) {
                ((ServerLevel)Sorcerer.this.level()).sendParticles((ParticleOptions)((SimpleParticleType)ModRegistry.MAGIC_FLAME_PARTICLE_TYPE.value()), target.getX(), target.getY() + 1.0, target.getZ(), 30, 0.3, 0.5, 0.3, 0.08);
            }
        }

        protected int getCastWarmupTime() {
            return 60;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 140;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.SORCERER_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return ModRegistry.CONJURE_FLAMES_ILLAGER_SPELL;
        }
    }
}

