/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.perk.data;

import com.aetherteam.aether.perk.types.DeveloperGlow;
import com.aetherteam.aether.perk.types.Halo;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.aether.perk.types.MoaSkins;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PerkSavedData
extends SavedData {
    public static final String FILE_NAME = "perks";
    private final Map<UUID, MoaData> storedSkinData = new HashMap<UUID, MoaData>();
    private final Map<UUID, Halo> storedHaloData = new HashMap<UUID, Halo>();
    private final Map<UUID, DeveloperGlow> storedDeveloperGlowData = new HashMap<UUID, DeveloperGlow>();

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        CompoundTag storedSkinDataTag = new CompoundTag();
        for (Map.Entry<UUID, MoaData> entry : this.storedSkinData.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            if (entry.getValue().moaUUID() != null) {
                compoundTag.putUUID("MoaUUID", entry.getValue().moaUUID());
            }
            if (entry.getValue().moaSkin() != null) {
                compoundTag.putString("MoaSkin", entry.getValue().moaSkin().getId());
            }
            storedSkinDataTag.put(entry.getKey().toString(), (Tag)compoundTag);
        }
        tag.put("StoredSkinData", (Tag)storedSkinDataTag);
        CompoundTag storedHaloDataTag = new CompoundTag();
        for (Map.Entry<UUID, Halo> entry : this.storedHaloData.entrySet()) {
            CompoundTag haloEntryTag = new CompoundTag();
            if (entry.getValue().hexColor() != null) {
                haloEntryTag.putString("HexColor", entry.getValue().hexColor());
            }
            storedHaloDataTag.put(entry.getKey().toString(), (Tag)haloEntryTag);
        }
        tag.put("StoredHaloData", (Tag)storedHaloDataTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<UUID, DeveloperGlow> developerGlowEntry : this.storedDeveloperGlowData.entrySet()) {
            CompoundTag developerGlowTag = new CompoundTag();
            if (developerGlowEntry.getValue().hexColor() != null) {
                developerGlowTag.putString("HexColor", developerGlowEntry.getValue().hexColor());
            }
            compoundTag.put(developerGlowEntry.getKey().toString(), (Tag)developerGlowTag);
        }
        tag.put("StoredDeveloperGlowData", (Tag)compoundTag);
        return tag;
    }

    public static PerkSavedData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        PerkSavedData data = PerkSavedData.create();
        for (String key : tag.getAllKeys()) {
            String hexColor;
            UUID playerUUID;
            if (key.equals("StoredSkinData")) {
                CompoundTag storedSkinDataTag = tag.getCompound(key);
                for (String storedSkinDataKey : storedSkinDataTag.getAllKeys()) {
                    CompoundTag moaDataEntryTag = storedSkinDataTag.getCompound(storedSkinDataKey);
                    playerUUID = UUID.fromString(storedSkinDataKey);
                    UUID moaUUID = null;
                    String moaSkinId = null;
                    if (moaDataEntryTag.contains("MoaUUID")) {
                        moaUUID = moaDataEntryTag.getUUID("MoaUUID");
                    }
                    if (moaDataEntryTag.contains("MoaSkin")) {
                        moaSkinId = moaDataEntryTag.getString("MoaSkin");
                    }
                    MoaSkins.MoaSkin moaSkin = MoaSkins.getMoaSkins().get(moaSkinId);
                    data.storedSkinData.put(playerUUID, new MoaData(moaUUID, moaSkin));
                }
            }
            if (key.equals("StoredHaloData")) {
                CompoundTag storedHaloDataTag = tag.getCompound(key);
                for (String storedHaloDataKey : storedHaloDataTag.getAllKeys()) {
                    CompoundTag haloEntryTag = storedHaloDataTag.getCompound(storedHaloDataKey);
                    playerUUID = UUID.fromString(storedHaloDataKey);
                    hexColor = null;
                    if (haloEntryTag.contains("HexColor")) {
                        hexColor = haloEntryTag.getString("HexColor");
                    }
                    data.storedHaloData.put(playerUUID, new Halo(hexColor));
                }
            }
            if (!key.equals("StoredDeveloperGlowData")) continue;
            CompoundTag storedDeveloperGlowDataTag = tag.getCompound(key);
            for (String storedDeveloperGlowDataKey : storedDeveloperGlowDataTag.getAllKeys()) {
                CompoundTag developerGlowEntryTag = storedDeveloperGlowDataTag.getCompound(storedDeveloperGlowDataKey);
                playerUUID = UUID.fromString(storedDeveloperGlowDataKey);
                hexColor = null;
                if (developerGlowEntryTag.contains("HexColor")) {
                    hexColor = developerGlowEntryTag.getString("HexColor");
                }
                data.storedDeveloperGlowData.put(playerUUID, new DeveloperGlow(hexColor));
            }
        }
        return data;
    }

    public static PerkSavedData create() {
        return new PerkSavedData();
    }

    public static PerkSavedData compute(DimensionDataStorage dataStorage) {
        return (PerkSavedData)dataStorage.computeIfAbsent(new SavedData.Factory(PerkSavedData::create, PerkSavedData::load, null), FILE_NAME);
    }

    Map<UUID, MoaData> getStoredSkinData() {
        return ImmutableMap.copyOf(this.storedSkinData);
    }

    void modifyStoredSkinData(UUID uuid, MoaData moaData) {
        this.storedSkinData.put(uuid, moaData);
        this.setDirty();
    }

    void removeStoredSkinData(UUID uuid) {
        this.storedSkinData.remove(uuid);
        this.setDirty();
    }

    Map<UUID, Halo> getStoredHaloData() {
        return ImmutableMap.copyOf(this.storedHaloData);
    }

    void modifyStoredHaloData(UUID uuid, Halo halo) {
        this.storedHaloData.put(uuid, halo);
        this.setDirty();
    }

    void removeStoredHaloData(UUID uuid) {
        this.storedHaloData.remove(uuid);
        this.setDirty();
    }

    Map<UUID, DeveloperGlow> getStoredDeveloperGlowData() {
        return ImmutableMap.copyOf(this.storedDeveloperGlowData);
    }

    void modifyStoredDeveloperGlowData(UUID uuid, DeveloperGlow developerGlow) {
        this.storedDeveloperGlowData.put(uuid, developerGlow);
        this.setDirty();
    }

    void removeStoredDeveloperGlowData(UUID uuid) {
        this.storedDeveloperGlowData.remove(uuid);
        this.setDirty();
    }
}

