/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.accessories.pendant;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.inventory.AetherAccessorySlots;
import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.item.accessories.SlotIdentifierHolder;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;

public class PendantItem
extends AccessoryItem
implements SlotIdentifierHolder {
    protected ResourceLocation PENDANT_LOCATION;

    public PendantItem(String pendantLocation, Holder<SoundEvent> pendantSound, Item.Properties properties) {
        this(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)pendantLocation), pendantSound, properties);
    }

    public PendantItem(ResourceLocation pendantLocation, Holder<SoundEvent> pendantSound, Item.Properties properties) {
        super(pendantSound, properties);
        this.setRenderTexture(pendantLocation.getNamespace(), pendantLocation.getPath());
    }

    public void setRenderTexture(String modId, String registryName) {
        this.PENDANT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)modId, (String)("textures/models/accessory/pendant/" + registryName + "_accessory.png"));
    }

    public ResourceLocation getPendantTexture() {
        return this.PENDANT_LOCATION;
    }

    @Override
    public SlotTypeReference getIdentifier() {
        return PendantItem.getStaticIdentifier();
    }

    public static SlotTypeReference getStaticIdentifier() {
        return (Boolean)AetherConfig.COMMON.use_default_accessories_menu.get() != false ? new SlotTypeReference("necklace") : AetherAccessorySlots.getPendantSlotType();
    }
}

