/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.LightningTrackerAttachment;
import com.aetherteam.aether.mixin.mixins.common.accessor.EntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public final class EntityUtil {
    public static void copyRotations(Entity entity, Entity source) {
        entity.setYRot((float)Mth.rotLerp((double)0.3333333333333333, (double)source.getYRot(), (double)source.yRotO));
        entity.setXRot((float)Mth.rotLerp((double)0.3333333333333333, (double)source.getXRot(), (double)source.xRotO));
        entity.setYBodyRot((float)Mth.rotLerp((double)0.3333333333333333, (double)source.getYRot(), (double)source.yRotO));
        entity.setYHeadRot((float)Mth.rotLerp((double)0.3333333333333333, (double)source.getYRot(), (double)source.yRotO));
    }

    public static void spawnMovementExplosionParticles(Entity entity) {
        RandomSource random = ((EntityAccessor)entity).aether$getRandom();
        double d0 = random.nextGaussian() * 0.02;
        double d1 = random.nextGaussian() * 0.02;
        double d2 = random.nextGaussian() * 0.02;
        double d3 = 10.0;
        double x = entity.getX() + (double)random.nextFloat() * (double)entity.getBbWidth() * 2.0 - (double)entity.getBbWidth() - d0 * d3;
        double y = entity.getY() + (double)random.nextFloat() * (double)entity.getBbHeight() - d1 * d3;
        double z = entity.getZ() + (double)random.nextFloat() * (double)entity.getBbWidth() * 2.0 - (double)entity.getBbWidth() - d2 * d3;
        entity.level().addParticle((ParticleOptions)ParticleTypes.POOF, x, y, z, d0, d1, d2);
    }

    public static void spawnSummoningExplosionParticles(Entity entity) {
        RandomSource random = ((EntityAccessor)entity).aether$getRandom();
        for (int i = 0; i < 20; ++i) {
            double d0 = random.nextGaussian() * 0.02;
            double d1 = random.nextGaussian() * 0.02;
            double d2 = random.nextGaussian() * 0.02;
            double d3 = 10.0;
            double x = entity.getX(0.0) - d0 * d3;
            double y = entity.getRandomY() - d1 * d3;
            double z = entity.getRandomZ(1.0) - d2 * d3;
            entity.level().addParticle((ParticleOptions)ParticleTypes.POOF, x, y, z, d0, d1, d2);
        }
    }

    public static void spawnRemovalParticles(Level level, BlockPos pos) {
        double a = (double)pos.getX() + 0.5 + (double)(level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.375;
        double b = (double)pos.getY() + 0.5 + (double)(level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.375;
        double c = (double)pos.getZ() + 0.5 + (double)(level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.375;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, a, b, c, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void summonLightningFromProjectile(Projectile projectile) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(projectile.level());
        if (lightningBolt != null) {
            ((LightningTrackerAttachment)lightningBolt.getData(AetherDataAttachments.LIGHTNING_TRACKER)).setOwner(projectile.getOwner());
            lightningBolt.setPos(projectile.getX(), projectile.getY(), projectile.getZ());
            projectile.level().addFreshEntity((Entity)lightningBolt);
        }
    }

    public static boolean wholeHitboxCanSeeSky(LevelAccessor level, BlockPos pos, int hitboxRadius) {
        boolean flag = true;
        for (int xOffset = -hitboxRadius; xOffset <= hitboxRadius; ++xOffset) {
            for (int zOffset = -hitboxRadius; zOffset <= hitboxRadius; ++zOffset) {
                flag = flag && level.canSeeSky(pos.offset(xOffset, 0, zOffset));
            }
        }
        return flag;
    }
}

