/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity;

import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.nitrogen.entity.BossMob;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;
import org.apache.commons.lang3.tuple.Pair;

public interface AetherBossMob<T extends Mob>
extends BossMob<T> {
    default public void closeRoom() {
        this.getDungeon().modifyRoom(state -> {
            if (state.getBlock() instanceof DoorwayBlock) {
                return (BlockState)state.setValue((Property)DoorwayBlock.INVISIBLE, (Comparable)Boolean.valueOf(false));
            }
            return null;
        });
    }

    default public void openRoom() {
        this.getDungeon().modifyRoom(state -> {
            if (state.getBlock() instanceof DoorwayBlock) {
                return (BlockState)state.setValue((Property)DoorwayBlock.INVISIBLE, (Comparable)Boolean.valueOf(true));
            }
            return null;
        });
    }

    default public void evaporate(T entity, BlockPos min, BlockPos max, Predicate<BlockState> check) {
        if (EventHooks.canEntityGrief((Level)entity.level(), entity)) {
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
                if (entity.level().getBlockState(pos).getBlock() instanceof LiquidBlock && check.test(entity.level().getBlockState(pos))) {
                    entity.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    this.evaporateEffects(entity, pos);
                    continue;
                }
                if (entity.level().getFluidState(pos).isEmpty() || !entity.level().getBlockState(pos).hasProperty((Property)BlockStateProperties.WATERLOGGED) || !check.test(entity.level().getFluidState(pos).createLegacyBlock())) continue;
                entity.level().setBlockAndUpdate(pos, (BlockState)entity.level().getBlockState(pos).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                this.evaporateEffects(entity, pos);
            }
        }
    }

    default public void evaporateEffects(T entity, BlockPos pos) {
        EntityUtil.spawnRemovalParticles(entity.level(), pos);
        entity.level().playSound(null, pos, (SoundEvent)AetherSoundEvents.WATER_EVAPORATE.get(), SoundSource.BLOCKS, 0.5f, 2.6f + (entity.level().getRandom().nextFloat() - entity.level().getRandom().nextFloat()) * 0.8f);
    }

    default public Pair<BlockPos, BlockPos> getDefaultBounds(T entity) {
        AABB boundingBox = entity.getBoundingBox();
        BlockPos min = BlockPos.containing((double)(boundingBox.minX - 1.0), (double)(boundingBox.minY - 1.0), (double)(boundingBox.minZ - 1.0));
        BlockPos max = BlockPos.containing((double)(Math.ceil(boundingBox.maxX - 1.0) + 1.0), (double)(Math.ceil(boundingBox.maxY - 1.0) + 1.0), (double)(Math.ceil(boundingBox.maxZ - 1.0) + 1.0));
        return Pair.of((Object)min, (Object)max);
    }

    @Nullable
    public ResourceLocation getBossBarTexture();

    @Nullable
    public ResourceLocation getBossBarBackgroundTexture();

    @Nullable
    default public Music getBossMusic() {
        return null;
    }
}

