/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.data.resources.registries.AetherStructures;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class AetherStructureSets {
    public static final ResourceKey<StructureSet> LARGE_AERCLOUD = AetherStructureSets.createKey("large_aercloud");
    public static final ResourceKey<StructureSet> BRONZE_DUNGEON = AetherStructureSets.createKey("bronze_dungeon");
    public static final ResourceKey<StructureSet> SILVER_AND_GOLD_DUNGEONS = AetherStructureSets.createKey("silver_and_gold_dungeons");

    private static ResourceKey<StructureSet> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)name));
    }

    public static void bootstrap(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        context.register(LARGE_AERCLOUD, (Object)new StructureSet((Holder)structures.getOrThrow(AetherStructures.LARGE_AERCLOUD), (StructurePlacement)new RandomSpreadStructurePlacement(6, 3, RandomSpreadType.LINEAR, 15536586)));
        Holder.Reference airborneSetHolder = context.register(SILVER_AND_GOLD_DUNGEONS, (Object)new StructureSet(List.of(StructureSet.entry((Holder)structures.getOrThrow(AetherStructures.SILVER_DUNGEON), (int)3), StructureSet.entry((Holder)structures.getOrThrow(AetherStructures.GOLD_DUNGEON), (int)1)), (StructurePlacement)new RandomSpreadStructurePlacement(36, 24, RandomSpreadType.LINEAR, 4325806)));
        context.register(BRONZE_DUNGEON, (Object)new StructureSet((Holder)structures.getOrThrow(AetherStructures.BRONZE_DUNGEON), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 32146754, Optional.of(new StructurePlacement.ExclusionZone((Holder)airborneSetHolder, 4)), 6, 5, RandomSpreadType.TRIANGULAR)));
    }
}

