/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.item.AetherItems;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AetherMoaTypes {
    public static final ResourceKey<Registry<MoaType>> MOA_TYPE_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"moa_type"));
    public static final ResourceKey<MoaType> BLUE = AetherMoaTypes.createKey("blue");
    public static final ResourceKey<MoaType> WHITE = AetherMoaTypes.createKey("white");
    public static final ResourceKey<MoaType> BLACK = AetherMoaTypes.createKey("black");

    private static ResourceKey<MoaType> createKey(String name) {
        return ResourceKey.create(MOA_TYPE_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)name));
    }

    public static void bootstrap(BootstrapContext<MoaType> context) {
        context.register(BLUE, (Object)new MoaType(new ItemStack((ItemLike)AetherItems.BLUE_MOA_EGG.get()), 3, 0.155f, 100, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/moa/blue_moa.png"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/moa/moa_saddle.png"), Optional.empty()));
        context.register(WHITE, (Object)new MoaType(new ItemStack((ItemLike)AetherItems.WHITE_MOA_EGG.get()), 4, 0.155f, 50, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/moa/white_moa.png"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/moa/moa_saddle.png"), Optional.empty()));
        context.register(BLACK, (Object)new MoaType(new ItemStack((ItemLike)AetherItems.BLACK_MOA_EGG.get()), 8, 0.155f, 25, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/moa/black_moa.png"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/moa/black_moa_saddle.png"), Optional.empty()));
    }

    @Nullable
    public static ResourceKey<MoaType> getResourceKey(RegistryAccess registryAccess, String location) {
        return AetherMoaTypes.getResourceKey(registryAccess, ResourceLocation.parse((String)location));
    }

    @Nullable
    public static ResourceKey<MoaType> getResourceKey(RegistryAccess registryAccess, ResourceLocation location) {
        MoaType moaType = AetherMoaTypes.getMoaType(registryAccess, location);
        if (moaType != null) {
            return registryAccess.registryOrThrow(MOA_TYPE_REGISTRY_KEY).getResourceKey((Object)moaType).orElse(null);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<MoaType> getResourceKey(RegistryAccess registryAccess, MoaType moaType) {
        return registryAccess.registryOrThrow(MOA_TYPE_REGISTRY_KEY).getResourceKey((Object)moaType).orElse(null);
    }

    @Nullable
    public static MoaType getMoaType(RegistryAccess registryAccess, String location) {
        return AetherMoaTypes.getMoaType(registryAccess, ResourceLocation.parse((String)location));
    }

    @Nullable
    public static MoaType getMoaType(RegistryAccess registryAccess, ResourceLocation location) {
        return (MoaType)registryAccess.registryOrThrow(MOA_TYPE_REGISTRY_KEY).get(location);
    }

    public static MoaType getWeightedChance(RegistryAccess registryAccess, RandomSource random) {
        Registry moaTypeRegistry = registryAccess.registryOrThrow(MOA_TYPE_REGISTRY_KEY);
        SimpleWeightedRandomList.Builder weightedListBuilder = SimpleWeightedRandomList.builder();
        moaTypeRegistry.holders().forEach(moaType -> weightedListBuilder.add((Object)((MoaType)moaType.value()), ((MoaType)moaType.value()).spawnChance()));
        SimpleWeightedRandomList weightedList = weightedListBuilder.build();
        Optional moaType2 = weightedList.getRandomValue(random);
        return moaType2.orElse((MoaType)moaTypeRegistry.get(BLUE));
    }
}

