/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.entity.passive.WingedAnimal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class QuadrupedWingsModel<T extends WingedAnimal>
extends EntityModel<T> {
    public final ModelPart leftWingInner;
    public final ModelPart leftWingOuter;
    public final ModelPart rightWingInner;
    public final ModelPart rightWingOuter;

    public QuadrupedWingsModel(ModelPart root) {
        this.leftWingInner = root.getChild("left_wing_inner");
        this.leftWingOuter = this.leftWingInner.getChild("left_wing_outer");
        this.rightWingInner = root.getChild("right_wing_inner");
        this.rightWingOuter = this.rightWingInner.getChild("right_wing_outer");
    }

    public static LayerDefinition createMainLayer(float offset) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition leftWingInnerDef = partDefinition.addOrReplaceChild("left_wing_inner", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, -16.0f, 0.0f, 2.0f, 16.0f, 8.0f), PartPose.offset((float)-4.0f, (float)(2.0f + offset), (float)-4.0f));
        leftWingInnerDef.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(-1.0f, -16.0f, 5.0E-4f, 2.0f, 16.0f, 7.999f), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition rightWingInnerDef = partDefinition.addOrReplaceChild("right_wing_inner", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -16.0f, 0.0f, 2.0f, 16.0f, 8.0f), PartPose.offset((float)4.0f, (float)(2.0f + offset), (float)-4.0f));
        rightWingInnerDef.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(20, 0).addBox(-1.0f, -16.0f, 5.0E-4f, 2.0f, 16.0f, 7.999f), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!Minecraft.getInstance().isPaused()) {
            float aimingForFold = ((MountableAnimal)entity).isEntityOnGround() ? 0.1f : 1.0f;
            ((WingedAnimal)entity).setWingAngle(((WingedAnimal)entity).getWingFold() * Mth.sin((float)(ageInTicks / 15.9f)));
            ((WingedAnimal)entity).setWingFold(((WingedAnimal)entity).getWingFold() + (aimingForFold - ((WingedAnimal)entity).getWingFold()) / 37.5f);
            float wingBend = -((float)Math.acos(((WingedAnimal)entity).getWingFold()));
            this.leftWingInner.zRot = -(((WingedAnimal)entity).getWingAngle() + wingBend + 1.5707964f);
            this.leftWingOuter.zRot = -(((WingedAnimal)entity).getWingAngle() - wingBend + 1.5707964f) - this.leftWingInner.zRot;
            this.rightWingInner.zRot = -this.leftWingInner.zRot;
            this.rightWingOuter.zRot = -this.leftWingOuter.zRot;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.leftWingInner.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rightWingInner.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

