/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.layers;

import com.aetherteam.aether.client.renderer.entity.model.SheepuffModel;
import com.aetherteam.aether.client.renderer.entity.model.SheepuffWoolModel;
import com.aetherteam.aether.entity.passive.Sheepuff;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class SheepuffWoolLayer
extends RenderLayer<Sheepuff, SheepuffModel> {
    private static final ResourceLocation SHEEPUFF_WOOL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/sheepuff/sheepuff_wool.png");
    private final SheepuffWoolModel wool;
    private final SheepuffWoolModel puffed;

    public SheepuffWoolLayer(RenderLayerParent<Sheepuff, SheepuffModel> entityRenderer, SheepuffWoolModel woolModel, SheepuffWoolModel puffedModel) {
        super(entityRenderer);
        this.wool = woolModel;
        this.puffed = puffedModel;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Sheepuff sheepuff, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!sheepuff.isSheared()) {
            SheepuffWoolModel woolModel;
            SheepuffWoolModel sheepuffWoolModel = woolModel = sheepuff.getPuffed() ? this.puffed : this.wool;
            if (sheepuff.isInvisible()) {
                Minecraft minecraft = Minecraft.getInstance();
                boolean flag = minecraft.shouldEntityAppearGlowing((Entity)sheepuff);
                if (flag) {
                    ((SheepuffModel)this.getParentModel()).copyPropertiesTo((EntityModel)woolModel);
                    woolModel.prepareMobModel(sheepuff, limbSwing, limbSwingAmount, partialTicks);
                    woolModel.setupAnim(sheepuff, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    VertexConsumer consumer = buffer.getBuffer(RenderType.outline((ResourceLocation)SHEEPUFF_WOOL_TEXTURE));
                    woolModel.renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)sheepuff, (float)0.0f), -16777216);
                }
            } else {
                int i;
                if (sheepuff.hasCustomName() && sheepuff.getName().getString().equals("jeb_")) {
                    int k = sheepuff.tickCount / 25 + sheepuff.getId();
                    int l = DyeColor.values().length;
                    int i1 = k % l;
                    int j1 = (k + 1) % l;
                    float f = ((float)(sheepuff.tickCount % 25) + partialTicks) / 25.0f;
                    int k1 = Sheep.getColor((DyeColor)DyeColor.byId((int)i1));
                    int l1 = Sheep.getColor((DyeColor)DyeColor.byId((int)j1));
                    i = FastColor.ARGB32.lerp((float)f, (int)k1, (int)l1);
                } else {
                    i = Sheepuff.getColor(sheepuff.getColor());
                }
                SheepuffWoolLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), (EntityModel)woolModel, (ResourceLocation)SHEEPUFF_WOOL_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)sheepuff, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (int)i);
            }
        }
    }
}

