/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc.tacz;

import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.api.event.common.GunDamageSourcePart;
import net.hackermdch.pgc.CustomAPI;
import net.hackermdch.pgc.GenshinCraftAPI;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;

public class TaczEventHandler {
    private static final ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"pgfs", (String)"tiankong");

    public static void register() {
        NeoForge.EVENT_BUS.addListener(TaczEventHandler::onEntityHurtByGun);
    }

    private static void onEntityHurtByGun(EntityHurtByGunEvent.Pre event) {
        if (event.getLogicalSide().isServer() && event.getGunId().equals((Object)id)) {
            Level level = event.getBullet().level();
            int type = level.random.nextInt(1, 8);
            DamageSource ds1 = TaczEventHandler.toElement(event.getDamageSource(GunDamageSourcePart.ARMOR_PIERCING), type, true, true);
            DamageSource ds2 = TaczEventHandler.toElement(event.getDamageSource(GunDamageSourcePart.NON_ARMOR_PIERCING), type, false, false);
            event.setDamageSource(GunDamageSourcePart.ARMOR_PIERCING, ds1);
            event.setDamageSource(GunDamageSourcePart.NON_ARMOR_PIERCING, ds2);
            Entity entity = event.getHurtEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity2 = (LivingEntity)entity;
            switch (type) {
                case 1: {
                    entity2.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 40, 0, false, false));
                    break;
                }
                case 3: {
                    LightningBolt lb = new LightningBolt(EntityType.LIGHTNING_BOLT, level);
                    lb.moveTo(entity2.position());
                    lb.setVisualOnly(true);
                    level.addFreshEntity((Entity)lb);
                    break;
                }
                case 4: {
                    entity2.addEffect(new MobEffectInstance(MobEffects.POISON, 40, 0, false, false));
                    break;
                }
                case 6: {
                    entity2.igniteForSeconds(3.0f);
                    break;
                }
                case 7: {
                    entity2.setTicksFrozen(60);
                }
            }
        }
    }

    private static DamageSource toElement(DamageSource original, int type, boolean apply, boolean critical) {
        return CustomAPI.GenshinCraftLoaded ? GenshinCraftAPI.toElement(original, type, 1.0f, apply, critical, false, false) : original;
    }
}

