/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc.rei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.hackermdch.pgc.CustomRegister;
import net.hackermdch.pgc.StardustConverterRecipe;
import net.hackermdch.pgc.network.WishInfoPacket;
import net.hackermdch.pgc.rei.ConvertCategory;
import net.hackermdch.pgc.rei.ConvertDisplay;
import net.hackermdch.pgc.rei.ForgeCategory;
import net.hackermdch.pgc.rei.ForgeDisplay;
import net.hackermdch.pgc.rei.Information;
import net.hackermdch.pgc.rei.LocalizedInformationDisplay;
import net.hackermdch.pgc.rei.PGCPlugin;
import net.hackermdch.pgc.rei.WishCategory;
import net.hackermdch.pgc.rei.WishDisplay;
import net.mcreator.ceshi.init.PrimogemcraftModEntities;
import net.mcreator.ceshi.init.PrimogemcraftModItems;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ItemLike;

@REIPluginClient
public class PGCClientPlugin
implements REIClientPlugin {
    private static final List<LocalizedInformationDisplay> displays = new ArrayList<LocalizedInformationDisplay>();

    static void updateInfo(List<Information> list) {
        HashMap multimap = new HashMap();
        for (Information information : list) {
            if (!multimap.containsKey(information.name())) {
                multimap.put(information.name(), new HashMap());
            }
            Map map = (Map)multimap.get(information.name());
            map.put(information.code(), information);
        }
        displays.clear();
        for (Map.Entry entry : multimap.entrySet()) {
            if (!((Map)entry.getValue()).containsKey("en_us") && !((Map)entry.getValue()).containsKey("zh_cn")) continue;
            displays.add(new LocalizedInformationDisplay((String)entry.getKey(), (Map)entry.getValue()));
        }
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add(new DisplayCategory[]{new WishCategory(), new ForgeCategory(), new ConvertCategory()});
        registry.addWorkstations(PGCPlugin.WISH, new EntryStack[]{EntryStacks.of(PrimogemcraftModItems.XIXIANGYUZHIYUAN), EntryStacks.of(PrimogemcraftModItems.JIJIUCHANZHIYUAN), EntryStacks.of(PrimogemcraftModItems.SHILIANCHOU), EntryStacks.of(PrimogemcraftModItems.QYHX_0WUJIACHENG), EntryStacks.of(PrimogemcraftModItems.QYHXSHILIAN)});
        registry.addWorkstations(PGCPlugin.FORGE, new EntryStack[]{EntryStacks.of(PrimogemcraftModItems.HUALIDUANZAO)});
        registry.addWorkstations(PGCPlugin.CONVERT, new EntryStack[]{EntryStacks.of(PrimogemcraftModItems.QXZHQ)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(StardustConverterRecipe.class, CustomRegister.STARDUST_CONVERTER.get(), ConvertDisplay::new);
        this.addWishEntry(registry, (EntityType<? extends LivingEntity>)((EntityType)PrimogemcraftModEntities.QQ_QYUANCHULAN_01.get()), WishInfoPacket.info[0]);
        this.addWishEntry(registry, (EntityType<? extends LivingEntity>)((EntityType)PrimogemcraftModEntities.Q_QYUANCHUZI_01.get()), WishInfoPacket.info[1]);
        this.addWishEntry(registry, (EntityType<? extends LivingEntity>)((EntityType)PrimogemcraftModEntities.QQIYUAN_JIN_GUANG.get()), WishInfoPacket.info[2]);
        registry.add((Display)new ForgeDisplay());
        displays.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
    }

    private void addWishEntry(DisplayRegistry registry, EntityType<? extends LivingEntity> type, Set<ItemLike> items) {
        for (ItemLike item : items) {
            registry.add((Display)new WishDisplay(type, (List<EntryIngredient>)ImmutableList.of((Object)EntryIngredients.of((ItemLike)item))));
        }
    }
}

