/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc.rei;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import net.hackermdch.pgc.rei.Information;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;

public class LocalizedInformationDisplay
extends DefaultInformationDisplay {
    private final Map<String, Information> information;
    private EntryIngredient entryStacks;
    private List<Component> texts;
    private String code;

    public LocalizedInformationDisplay(String name, Map<String, Information> infos) {
        super(null, (Component)Component.literal((String)name));
        this.information = infos;
    }

    private void update() {
        String lang = Minecraft.getInstance().getLanguageManager().getSelected();
        if (lang.equals(this.code)) {
            return;
        }
        this.code = lang;
        EntryIngredient.Builder builder = EntryIngredient.builder();
        Information info = this.information.containsKey(lang) ? this.information.get(lang) : (this.information.containsKey("en_us") ? this.information.get("en_us") : this.information.get("zh_cn"));
        for (String s : info.items()) {
            if (s.startsWith("#")) {
                builder.addAll((Iterable)EntryIngredients.ofItemTag((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)s.substring(1)))));
                continue;
            }
            builder.add(EntryStacks.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)s)))));
        }
        this.entryStacks = builder.build();
        this.texts = info.lines();
    }

    public List<EntryIngredient> getInputEntries() {
        this.update();
        return Collections.singletonList(this.entryStacks);
    }

    public List<EntryIngredient> getOutputEntries() {
        this.update();
        return Collections.singletonList(this.entryStacks);
    }

    public EntryIngredient getEntryStacks() {
        this.update();
        return this.entryStacks;
    }

    public List<Component> getTexts() {
        this.update();
        return this.texts;
    }
}

