/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc.rei;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.hackermdch.pgc.rei.PGCClientPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

@EventBusSubscriber(modid="primogemcraft", bus=EventBusSubscriber.Bus.MOD)
public record Information(String code, String name, List<String> items, List<Component> lines) {
    @SubscribeEvent
    private static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        if (!ModList.get().isLoaded("roughlyenoughitems")) {
            return;
        }
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
            Map infos = resourceManager.listResources("rei_info", id -> id.getPath().endsWith(".txt"));
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry it : infos.entrySet()) {
                try {
                    BufferedReader br = ((Resource)it.getValue()).openAsReader();
                    try {
                        List<String> lines = br.lines().toList();
                        List<String> items = Arrays.stream(lines.getFirst().split(",")).map(String::trim).toList();
                        ImmutableList.Builder components = ImmutableList.builder();
                        for (int i = 1; i < lines.size(); ++i) {
                            components.add((Object)Component.literal((String)lines.get(i)));
                        }
                        String path = ((ResourceLocation)it.getKey()).getPath();
                        path = path.substring(path.indexOf(47) + 1);
                        String code = path.substring(0, path.indexOf(47));
                        path = path.substring(path.indexOf(47) + 1);
                        path = path.substring(0, path.lastIndexOf(46));
                        builder.add((Object)new Information(code, ((ResourceLocation)it.getKey()).withPath(path).toString(), items, (List<Component>)components.build()));
                    }
                    finally {
                        if (br == null) continue;
                        br.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            PGCClientPlugin.updateInfo((List<Information>)builder.build());
        }));
    }
}

