/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc.network;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.hackermdch.pgc.CustomAPI;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class WishInfoPacket
implements CustomPacketPayload {
    public static final Set<ItemLike>[] info = new Set[3];
    private static final CustomPacketPayload.Type<WishInfoPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"primogemcraft", (String)"wish_info"));
    private final Set<Holder<Item>> items;
    private final RegistryAccess registry;
    private final int index;

    public WishInfoPacket(Set<Holder<Item>> items, int index, RegistryAccess registry) {
        this.items = items;
        this.index = index;
        this.registry = registry;
    }

    private WishInfoPacket(FriendlyByteBuf buf) {
        this.registry = CustomAPI.registryAccess();
        this.index = buf.readInt();
        int size = buf.readInt();
        StreamCodec codec = ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        RegistryFriendlyByteBuf regBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.registry, ConnectionType.NEOFORGE);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)((Holder)codec.decode((Object)regBuf)));
        }
        this.items = builder.build();
    }

    private void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.index);
        buf.writeInt(this.items.size());
        RegistryFriendlyByteBuf regBuf = new RegistryFriendlyByteBuf((ByteBuf)buf, this.registry, ConnectionType.NEOFORGE);
        StreamCodec codec = ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM);
        for (Holder<Item> item : this.items) {
            codec.encode((Object)regBuf, item);
        }
    }

    private void handle(IPayloadContext context) {
        WishInfoPacket.info[this.index] = (Set)this.items.stream().map(Holder::value).collect(ImmutableSet.toImmutableSet());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.configurationToClient(TYPE, StreamCodec.ofMember(WishInfoPacket::encode, WishInfoPacket::new), WishInfoPacket::handle);
        registrar.playToClient(TYPE, StreamCodec.ofMember(WishInfoPacket::encode, WishInfoPacket::new), WishInfoPacket::handle);
    }
}

