/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc.network;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.hackermdch.pgc.network.WishInfoPacket;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="primogemcraft")
public record WishInfoConfiguration(ServerConfigurationPacketListener listener) implements ICustomConfigurationTask
{
    private static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(ResourceLocation.fromNamespaceAndPath((String)"primogemcraft", (String)"wish_info"));
    private static final boolean loaded = ModList.get().isLoaded("roughlyenoughitems");
    private static Set<Holder<Item>> items;
    private static Set<Holder<Item>> items1;
    private static Set<Holder<Item>> items2;
    private static final Set<ResourceLocation> r;
    private static final Set<ResourceLocation> sr;
    private static final Set<ResourceLocation> ssr;
    private static RegistryAccess registry;

    public void run(@NotNull Consumer<CustomPacketPayload> sender) {
        sender.accept(new WishInfoPacket(items, 0, registry));
        sender.accept(new WishInfoPacket(items1, 1, registry));
        sender.accept(new WishInfoPacket(items2, 2, registry));
        this.listener.finishCurrentTask(TYPE);
    }

    @NotNull
    public ConfigurationTask.Type type() {
        return TYPE;
    }

    @SubscribeEvent
    private static void onReload(AddReloadListenerEvent event) {
        if (!loaded) {
            return;
        }
        HolderGetter.Provider provider = event.getRegistryAccess().asGetterLookup();
        registry = event.getRegistryAccess();
        items = WishInfoConfiguration.getItems(provider, r);
        items1 = WishInfoConfiguration.getItems(provider, sr);
        items2 = WishInfoConfiguration.getItems(provider, ssr);
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WishInfoPacket(items, 0, registry), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WishInfoPacket(items1, 1, registry), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WishInfoPacket(items2, 2, registry), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void addRare(ResourceLocation lootTable) {
        r.add(lootTable);
    }

    public static void addSuperRare(ResourceLocation lootTable) {
        sr.add(lootTable);
    }

    public static void addSuperSuperRare(ResourceLocation lootTable) {
        ssr.add(lootTable);
    }

    private static Set<Holder<Item>> getItems(HolderGetter.Provider provider, Set<ResourceLocation> lootTables) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ResourceLocation id : lootTables) {
            WishInfoConfiguration.getItems(provider, id, (ImmutableSet.Builder<Holder<Item>>)builder);
        }
        return builder.build();
    }

    private static void getItems(HolderGetter.Provider provider, ResourceLocation id, ImmutableSet.Builder<Holder<Item>> builder) {
        provider.get(Registries.LOOT_TABLE, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id)).ifPresent(table -> ((LootTable)table.value()).pools.forEach(pool -> pool.entries.forEach(entry -> {
            if (entry instanceof LootItem) {
                LootItem item = (LootItem)entry;
                builder.add((Object)item.item);
            }
        })));
    }

    static {
        r = new HashSet<ResourceLocation>();
        sr = new HashSet<ResourceLocation>();
        ssr = new HashSet<ResourceLocation>();
    }
}

