/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc.network;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.FireworkExplosion;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class ParticlePacket
implements CustomPacketPayload {
    private static final CustomPacketPayload.Type<ParticlePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"primogemcraft", (String)"custom_particle"));
    private final int particle;
    private final double x;
    private final double y;
    private final double z;

    public ParticlePacket(int particle, double x, double y, double z) {
        this.particle = particle;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private ParticlePacket(FriendlyByteBuf buf) {
        this.particle = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    private void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.particle);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    private void handle(IPayloadContext context) {
        assert (Minecraft.getInstance().level != null);
        switch (this.particle) {
            case 0: {
                IntList colors = IntList.of((int)16752608, (int)11464191);
                IntList fadeColors = IntList.of((int)16041727);
                FireworkParticles.Starter pt = new FireworkParticles.Starter(Minecraft.getInstance().level, this.x, this.y, this.z, 0.0, 0.0, 0.0, Minecraft.getInstance().particleEngine, List.of(FireworkExplosion.DEFAULT));
                pt.createParticleBall(0.5, 3, colors, fadeColors, true, false);
                break;
            }
            case 1: {
                IntList colors = IntList.of((int)16752608, (int)11464191, (int)16041727);
                IntList fadeColors = IntList.of();
                FireworkParticles.Starter pt = new FireworkParticles.Starter(Minecraft.getInstance().level, this.x, this.y, this.z, 0.0, 0.0, 0.0, Minecraft.getInstance().particleEngine, List.of(FireworkExplosion.DEFAULT));
                pt.createParticleBall(0.5, 5, colors, fadeColors, true, true);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToClient(TYPE, StreamCodec.ofMember(ParticlePacket::encode, ParticlePacket::new), ParticlePacket::handle);
    }
}

