/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc.mixin;

import com.google.common.collect.ImmutableSet;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.mcreator.ceshi.GlobalAttributeModifier;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.common.util.Lazy;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Inventory.class})
public abstract class InventoryMixin
implements Container,
Nameable {
    @Shadow
    @Final
    public Player player;
    @Unique
    private static final Lazy<Set<Item>> items = Lazy.of(() -> (Set)GlobalAttributeModifier.inventoryAttributeItems.stream().map(s -> (Item)((Holder.Reference)BuiltInRegistries.ITEM.getHolder(ResourceLocation.parse((String)s)).orElseThrow()).value()).collect(ImmutableSet.toImmutableSet()));
    @Unique
    private final Set<ItemStack> cache = new ObjectArraySet();
    @Unique
    private final Set<ItemStack> snapshot = new ObjectArraySet();

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;inventoryTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;IZ)V")})
    private void inventoryTick(CallbackInfo ci, @Local(ordinal=1) int i, @Local NonNullList<ItemStack> stacks) {
        if (this.player.level().isClientSide) {
            return;
        }
        ItemStack item = (ItemStack)stacks.get(i);
        if (((Set)items.get()).contains(item.getItem())) {
            boolean flag = false;
            for (ItemAttributeModifiers.Entry m : item.getAttributeModifiers().modifiers()) {
                AttributeInstance attributeInstance;
                AttributeMap attr;
                if (m.slot() != EquipmentSlotGroup.ANY || (attr = this.player.getAttributes()).hasModifier(m.attribute(), m.modifier().id()) || !((attributeInstance = attr.getInstance(m.attribute())) instanceof AttributeInstance)) continue;
                AttributeInstance ins = attributeInstance;
                ins.addTransientModifier(m.modifier());
                flag = true;
            }
            ItemStack copy = item.copy();
            if (flag) {
                this.cache.add(copy);
            }
            this.snapshot.add(copy);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        if (this.player.level().isClientSide) {
            return;
        }
        this.cache.removeIf(item -> {
            if (this.snapshot.stream().noneMatch(i -> ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)i))) {
                item.getAttributeModifiers().modifiers().forEach(m -> {
                    AttributeInstance patt0$temp;
                    AttributeMap attr;
                    if (m.slot() == EquipmentSlotGroup.ANY && (attr = this.player.getAttributes()).hasModifier(m.attribute(), m.modifier().id()) && (patt0$temp = attr.getInstance(m.attribute())) instanceof AttributeInstance) {
                        AttributeInstance ins = patt0$temp;
                        ins.removeModifier(m.modifier());
                    }
                });
                return true;
            }
            return false;
        });
        this.snapshot.clear();
    }
}

