/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.hackermdch.pgc.CustomRegister;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public final class StardustConverterRecipe
implements Recipe<RecipeInput> {
    private static final Supplier<RecipeSerializer<?>> STARDUST_CONVERTER = CustomRegister.RECIPE_SERIALIZERS.register("stardust_converter", Serializer::new);
    private final ItemStack first;
    private final ItemStack second;
    private final int cost;

    private StardustConverterRecipe(ItemStack first, ItemStack second, int cost) {
        this.first = first;
        this.second = second;
        this.cost = cost;
    }

    public static void register() {
    }

    public Data match(ItemStack item, boolean reverse) {
        if (reverse) {
            if (ItemStack.isSameItemSameComponents((ItemStack)this.second, (ItemStack)item) && item.getCount() >= this.second.getCount()) {
                return new Data(this.second.copy(), this.first.copy(), this.cost);
            }
        } else if (ItemStack.isSameItemSameComponents((ItemStack)this.first, (ItemStack)item) && item.getCount() >= this.first.getCount()) {
            return new Data(this.first.copy(), this.second.copy(), this.cost);
        }
        return null;
    }

    public Data get() {
        return new Data(this.first.copy(), this.second.copy(), this.cost);
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return STARDUST_CONVERTER.get();
    }

    public RecipeType<?> getType() {
        return CustomRegister.STARDUST_CONVERTER.get();
    }

    public record Data(ItemStack input, ItemStack output, int cost) {
    }

    private static class Serializer
    implements RecipeSerializer<StardustConverterRecipe> {
        private static final MapCodec<StardustConverterRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("first").forGetter(recipe -> recipe.first), (App)ItemStack.STRICT_CODEC.fieldOf("second").forGetter(recipe -> recipe.second), (App)Codec.INT.fieldOf("cost").forGetter(recipe -> recipe.cost)).apply((Applicative)instance, StardustConverterRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, StardustConverterRecipe> STREAM_CODEC = StreamCodec.of(Serializer::encode, Serializer::decode);

        private Serializer() {
        }

        public MapCodec<StardustConverterRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, StardustConverterRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static StardustConverterRecipe decode(RegistryFriendlyByteBuf buffer) {
            return new StardustConverterRecipe((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readInt());
        }

        private static void encode(RegistryFriendlyByteBuf buffer, StardustConverterRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.first);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.second);
            buffer.writeInt(recipe.cost);
        }
    }
}

