/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.hackermdch.pgc.CustomBar;
import net.hackermdch.pgc.CustomComponents;
import net.hackermdch.pgc.CustomRegister;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class ShapedWithComponentsRecipe
implements CraftingRecipe {
    private static final Supplier<RecipeSerializer<?>> CRAFTING_SHAPED_WITH_COMPONENTS = CustomRegister.RECIPE_SERIALIZERS.register("crafting_shaped_with_components", Serializer::new);
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final String source;
    private final String group;
    private final CraftingBookCategory category;
    private final boolean showNotification;

    public static void register() {
    }

    public ShapedWithComponentsRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, String source, boolean showNotification) {
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = result;
        this.source = source;
        this.showNotification = showNotification;
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        return this.pattern.matches(input);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registries) {
        ItemStack result = this.getResultItem(registries).copy();
        for (ItemStack it : inv.items()) {
            if ((!this.source.startsWith("#") || !it.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)this.source.substring(1))))) && !it.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.source)))) continue;
            CustomBar com = (CustomBar)result.get(CustomComponents.CUSTOM_BAR);
            result.applyComponents(it.getComponents());
            CustomBar bar = (CustomBar)result.get(CustomComponents.CUSTOM_BAR);
            if (bar != null) {
                bar = new CustomBar(bar.numerator, com != null ? com.denominator : bar.denominator, bar.visible);
                result.set(CustomComponents.CUSTOM_BAR, (Object)bar);
            }
            return result;
        }
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.pattern.width() && height >= this.pattern.height();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return CRAFTING_SHAPED_WITH_COMPONENTS.get();
    }

    @NotNull
    public CraftingBookCategory category() {
        return this.category;
    }

    public boolean isIncomplete() {
        NonNullList<Ingredient> ingredients = this.getIngredients();
        return ingredients.isEmpty() || ingredients.stream().filter(it -> !it.isEmpty()).anyMatch(Ingredient::hasNoItems);
    }

    private static class Serializer
    implements RecipeSerializer<ShapedWithComponentsRecipe> {
        private static final MapCodec<ShapedWithComponentsRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.STRING.fieldOf("source").forGetter(recipe -> recipe.source), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, ShapedWithComponentsRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ShapedWithComponentsRecipe> STREAM_CODEC = StreamCodec.of(Serializer::encode, Serializer::decode);

        private Serializer() {
        }

        @NotNull
        public MapCodec<ShapedWithComponentsRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ShapedWithComponentsRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedWithComponentsRecipe decode(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            String source = buffer.readUtf();
            boolean showNotification = buffer.readBoolean();
            return new ShapedWithComponentsRecipe(group, category, pattern, result, source, showNotification);
        }

        private static void encode(RegistryFriendlyByteBuf buffer, ShapedWithComponentsRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeEnum((Enum)recipe.category);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeUtf(recipe.source);
            buffer.writeBoolean(recipe.showNotification);
        }
    }
}

