/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc;

import java.util.function.Supplier;
import net.hackermdch.pgc.CustomComponents;
import net.hackermdch.pgc.IsChestCondition;
import net.hackermdch.pgc.MaterialRecoveryRecipe;
import net.hackermdch.pgc.ShapedWithComponentsRecipe;
import net.hackermdch.pgc.StardustConverterRecipe;
import net.hackermdch.pgc.network.WishInfoConfiguration;
import net.hackermdch.pgc.tacz.TaczEventHandler;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CustomRegister {
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITION_TYPES = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"primogemcraft");
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"primogemcraft");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"primogemcraft");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"primogemcraft");
    public static final Supplier<LootItemConditionType> IS_CHEST = LOOT_CONDITION_TYPES.register("is_chest", () -> new LootItemConditionType(IsChestCondition.CODEC));
    public static final Supplier<RecipeType<StardustConverterRecipe>> STARDUST_CONVERTER = RECIPE_TYPES.register("stardust_converter", () -> new RecipeType<StardustConverterRecipe>(){

        public String toString() {
            return String.format("%s:%s", "primogemcraft", "stardust_converter");
        }
    });

    public static void register(IEventBus modBus) {
        LOOT_CONDITION_TYPES.register(modBus);
        DATA_COMPONENT_TYPES.register(modBus);
        RECIPE_TYPES.register(modBus);
        RECIPE_SERIALIZERS.register(modBus);
        if (ModList.get().isLoaded("tacz")) {
            TaczEventHandler.register();
        }
    }

    static {
        DATA_COMPONENT_TYPES.register("custom_bar", () -> CustomComponents.CUSTOM_BAR);
        DATA_COMPONENT_TYPES.register("element_type", () -> CustomComponents.ELEMENT_TYPE);
        DATA_COMPONENT_TYPES.register("yszujian_jian", () -> CustomComponents.YSZUJIAN_JIAN);
        ShapedWithComponentsRecipe.register();
        MaterialRecoveryRecipe.register();
        StardustConverterRecipe.register();
        WishInfoConfiguration.addRare(ResourceLocation.fromNamespaceAndPath((String)"primogemcraft", (String)"qq_qqylan"));
        WishInfoConfiguration.addSuperRare(ResourceLocation.fromNamespaceAndPath((String)"primogemcraft", (String)"q_qqyzi"));
        WishInfoConfiguration.addSuperSuperRare(ResourceLocation.fromNamespaceAndPath((String)"primogemcraft", (String)"qqyjin"));
    }
}

