/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hackermdch.pgc.AttributeWrapper;
import net.hackermdch.pgc.CustomBar;
import net.hackermdch.pgc.CustomComponents;
import net.hackermdch.pgc.CustomRegister;
import net.hackermdch.pgc.StardustConverterRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class CustomAPI {
    public static final boolean GenshinCraftLoaded = ModList.get().isLoaded("genshincraft");
    static final Map<Item, CustomBar> defaults = new HashMap<Item, CustomBar>();

    public static CustomBar getCustomBar(ItemStack stack) {
        CustomBar bar = (CustomBar)stack.get(CustomComponents.CUSTOM_BAR);
        if (defaults.get(stack.getItem()).equals(bar)) {
            bar = new CustomBar(bar.numerator, bar.denominator, bar.visible);
            stack.set(CustomComponents.CUSTOM_BAR, (Object)bar);
        }
        return bar;
    }

    public static boolean hasCustomBar(ItemStack stack) {
        return stack.has(CustomComponents.CUSTOM_BAR);
    }

    public static AttributeWrapper getAttributes(ItemStack stack) {
        return new AttributeWrapper(stack);
    }

    public static Pair<StardustConverterRecipe.Data, StardustConverterRecipe.Data> findConvertRecipe(LevelAccessor level, double x, double y, double z) {
        ILevelExtension ext;
        IItemHandler inv;
        StardustConverterRecipe.Data r1 = null;
        StardustConverterRecipe.Data r2 = null;
        if (level.getServer() != null && level instanceof ILevelExtension && (inv = (IItemHandler)(ext = (ILevelExtension)level).getCapability(Capabilities.ItemHandler.BLOCK, new BlockPos((int)x, (int)y, (int)z), null)) != null) {
            ItemStack item1 = inv.getStackInSlot(1);
            ItemStack item2 = inv.getStackInSlot(3);
            List recipes = level.getServer().getRecipeManager().getAllRecipesFor(CustomRegister.STARDUST_CONVERTER.get());
            for (RecipeHolder r : recipes) {
                StardustConverterRecipe.Data data;
                if (r1 == null && (data = ((StardustConverterRecipe)r.value()).match(item1, false)) != null) {
                    r1 = data;
                }
                if (r2 == null && (data = ((StardustConverterRecipe)r.value()).match(item2, true)) != null) {
                    r2 = data;
                }
                if (r1 == null || r2 == null) continue;
                break;
            }
        }
        return new Pair(r1, r2);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private static ClientPacketListener connection() {
        if (Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.connection;
        }
        if (Minecraft.getInstance().getConnection() != null) {
            return Minecraft.getInstance().getConnection();
        }
        if (Minecraft.getInstance().gameMode != null) {
            return Minecraft.getInstance().gameMode.connection;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RegistryAccess registryAccess() {
        RegistryAccess.Frozen frozen;
        ClientPacketListener clientPacketListener = CustomAPI.connection();
        if (clientPacketListener instanceof ClientPacketListener) {
            ClientPacketListener c = clientPacketListener;
            frozen = c.registryAccess();
        } else {
            frozen = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        }
        return frozen;
    }
}

