/*
 * Decompiled with CFR 0.152.
 */
package net.hackermdch.pgc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class AttributeWrapper {
    private final List<ItemAttributeModifiers.Entry> entries = new ArrayList<ItemAttributeModifiers.Entry>();
    private final ItemStack item;

    AttributeWrapper(ItemStack stack) {
        this.item = stack;
    }

    public void add(String attr, String id, double amount, AttributeModifier.Operation operation, EquipmentSlotGroup group) {
        this.entries.add(new ItemAttributeModifiers.Entry((Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)attr)).orElseThrow(), new AttributeModifier(ResourceLocation.parse((String)id), amount, operation), group));
    }

    public void add(Holder<Attribute> attr, String id, double amount, AttributeModifier.Operation operation, EquipmentSlotGroup group) {
        this.entries.add(new ItemAttributeModifiers.Entry(attr, new AttributeModifier(ResourceLocation.parse((String)id), amount, operation), group));
    }

    public void add(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
        this.entries.add(new ItemAttributeModifiers.Entry(attribute, modifier, slot));
    }

    public void apply() {
        if (this.entries.isEmpty()) {
            this.item.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        ((ItemAttributeModifiers)this.item.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).modifiers().forEach(e -> {
            if (this.entries.stream().noneMatch(e2 -> e.matches(e2.attribute(), e2.modifier().id()))) {
                builder.add(e);
            }
        });
        builder.addAll(this.entries);
        this.item.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers((List)builder.build(), true));
    }
}

