/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.disenchanting_table.core.world.block.entity;

import common.com.cursee.disenchanting_table.core.ServerConfig;
import common.com.cursee.disenchanting_table.core.registry.ModBlockEntities;
import common.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import common.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import common.com.cursee.disenchanting_table.core.util.S2CBlockEntityUpdatePacket;
import common.com.cursee.disenchanting_table.core.world.block.entity.util.ExposedSimpleInventoryBlockEntity;
import common.com.cursee.disenchanting_table.core.world.block.entity.util.SimpleInventoryBlockEntity;
import common.com.cursee.disenchanting_table.core.world.inventory.DisenchantingMenu;
import common.com.cursee.disenchanting_table.core.world.inventory.DisenchantingTableMenu;
import common.com.cursee.disenchanting_table.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DisenchantingTableBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements MenuProvider {
    public static final int INPUT_SLOT = 0;
    public static final int EXTRA_SLOT = 1;
    public static final int OUTER_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    private int signal = 0;
    private boolean dirty = false;
    private static final int MAX_PROGRESS = 10;
    private int progress = 0;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int i) {
            if (i == 0) {
                return DisenchantingTableBlockEntity.this.progress;
            }
            return 0;
        }

        public void set(int i, int v) {
            if (i == 0) {
                DisenchantingTableBlockEntity.this.progress = v;
            }
        }

        public int getCount() {
            return 1;
        }
    };
    private Holder<Enchantment> keptEnchantment = null;
    private Integer keptEnchantmentLevel = null;
    private ItemEnchantments stolenEnchantments = null;

    public DisenchantingTableBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.DISENCHANTING_TABLE, pos, blockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"itemGroup.disenchantingTable");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        if (this.level == null) {
            return null;
        }
        return ServerConfig.automatic_disenchanting ? new DisenchantingTableMenu(i, inventory, (Container)this, this.dataAccess) : new DisenchantingMenu(i, inventory, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    @Override
    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (!ServerConfig.automatic_disenchanting) {
            return false;
        }
        if (index == 0 && !DisenchantmentHelper.canDisenchant(stack)) {
            return true;
        }
        return index == 2;
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(this, 3){

            public boolean canPlaceItem(int index, ItemStack stack) {
                if (!ServerConfig.automatic_disenchanting) {
                    return false;
                }
                return index == 0 && DisenchantmentHelper.canDisenchant(stack) || index == 1 && stack.is(Items.BOOK);
            }
        };
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, DisenchantingTableBlockEntity table) {
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, DisenchantingTableBlockEntity table) {
        boolean validInputs;
        if (!ServerConfig.automatic_disenchanting) {
            return;
        }
        Player player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 16.0, false);
        if (player == null || !DisenchantingTableBlockEntity.hasEnoughExperience(player)) {
            return;
        }
        boolean bl = validInputs = DisenchantmentHelper.canDisenchant(table.getItem(0)) && table.getItem(1).is(Items.BOOK);
        if (validInputs && table.getItem(2).isEmpty()) {
            if (table.progress >= 10) {
                table.disenchant(level, pos, player);
                level.levelEvent(1503, pos, 0);
                table.progress = 0;
            }
            ++table.progress;
            table.dirty = true;
        } else {
            table.progress = 0;
        }
        int newSignal = 0;
        Container container = table.getItemHandler();
        if (!container.isEmpty()) {
            if (!container.getItem(0).isEmpty()) {
                newSignal = 3;
                if (!container.getItem(1).isEmpty()) {
                    newSignal = 6;
                }
            }
            if (!container.getItem(2).isEmpty()) {
                newSignal = 9;
            }
        }
        if (newSignal != table.signal) {
            table.signal = newSignal;
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
        if (table.dirty) {
            table.dirty = false;
            S2CBlockEntityUpdatePacket.sendToClients(table);
        }
    }

    private static boolean hasEnoughExperience(Player player) {
        if (!ServerConfig.requires_experience) {
            return true;
        }
        if (ServerConfig.uses_points && ExperienceHelper.hasEnoughExperiencePoints(player, ServerConfig.experience_cost)) {
            return true;
        }
        if (!ServerConfig.uses_points && ExperienceHelper.hasEnoughExperienceLevels(player, ServerConfig.experience_cost)) {
            return true;
        }
        return player.isCreative();
    }

    private void disenchant(Level level, BlockPos pos, Player player) {
        ItemStack input = this.getItem(0);
        if (!input.is(Items.ENCHANTED_BOOK)) {
            this.stolenEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
            ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)this.stolenEnchantments);
            if (ServerConfig.resets_repair_cost) {
                result.set(DataComponents.REPAIR_COST, (Object)0);
            }
            this.setItem(2, result);
            EnchantmentHelper.setEnchantments((ItemStack)input, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)ItemStack.EMPTY));
            if (ServerConfig.resets_repair_cost) {
                input.set(DataComponents.REPAIR_COST, (Object)0);
            }
            this.setItem(0, input);
            this.removeNormalBook();
        } else {
            this.stolenEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
            this.keptEnchantment = (Holder)this.stolenEnchantments.keySet().iterator().next();
            this.keptEnchantmentLevel = this.stolenEnchantments.getLevel(this.keptEnchantment);
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(this.stolenEnchantments);
            mutable.removeIf(enchantmentHolder -> enchantmentHolder.value() == this.keptEnchantment.value());
            this.stolenEnchantments = mutable.toImmutable();
            ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)this.stolenEnchantments);
            if (ServerConfig.resets_repair_cost) {
                result.set(DataComponents.REPAIR_COST, (Object)0);
            }
            this.setItem(2, result);
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == null) {
                return;
            }
            ItemStack keptEnchantedBook = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(this.keptEnchantment, this.keptEnchantmentLevel.intValue()));
            if (ServerConfig.resets_repair_cost) {
                keptEnchantedBook.set(DataComponents.REPAIR_COST, (Object)0);
            }
            this.setItem(0, keptEnchantedBook);
            this.removeNormalBook();
        }
        if (!player.isCreative()) {
            if (ServerConfig.uses_points) {
                ExperienceHelper.deductExperiencePoints(player, ServerConfig.experience_cost);
            } else {
                ExperienceHelper.deductExperienceLevels(player, ServerConfig.experience_cost);
            }
        }
    }

    public void removeNormalBook() {
        ItemStack bookStack = this.getItem(1);
        bookStack.shrink(1);
        this.setItem(1, bookStack);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.progress = tag.getInt("Progress");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("Progress", this.progress);
        super.saveAdditional(tag, registries);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.dirty = true;
            for (Player player : this.level.players()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Services.PLATFORM.sendItemSyncToClient(serverPlayer, SimpleInventoryBlockEntity.copyFromInv((Container)this), this.getBlockPos());
            }
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public int getSignal() {
        return this.signal;
    }

    public ItemStack getRenderStack() {
        return !this.getItem(2).isEmpty() ? this.getItem(2) : this.getItem(0);
    }
}

