/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia;

import com.vsngarcia.Config;
import com.vsngarcia.level.ElevatorBlockEntityBase;
import com.vsngarcia.util.FakeUseContext;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ElevatorBlockBase
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty DIRECTIONAL = BooleanProperty.create((String)"directional");
    public static final BooleanProperty SHOW_ARROW = BooleanProperty.create((String)"show_arrow");
    private final DyeColor dyeColor;
    private final Supplier<BlockEntityType<? extends ElevatorBlockEntityBase>> tileEntityType;

    public ElevatorBlockBase(DyeColor color, Supplier<BlockEntityType<? extends ElevatorBlockEntityBase>> type) {
        super(BlockBehaviour.Properties.of().mapColor(color).sound(SoundType.WOOL).strength(0.8f).dynamicShape().noOcclusion().isValidSpawn(ElevatorBlockBase.isValidSpawn(type)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DIRECTIONAL, (Comparable)Boolean.valueOf(false))).setValue((Property)SHOW_ARROW, (Comparable)Boolean.valueOf(true)));
        this.dyeColor = color;
        this.tileEntityType = type;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, DIRECTIONAL, SHOW_ARROW});
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    protected abstract void openMenu(Player var1, ElevatorBlockEntityBase var2, BlockPos var3);

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        return this.getElevatorTile((BlockGetter)worldIn, pos).map(tile -> {
            Block handBlock = Block.byItem((Item)player.getItemInHand(handIn).getItem());
            BlockState stateToApply = handBlock.getStateForPlacement((BlockPlaceContext)new FakeUseContext(player, handIn, hit));
            if (stateToApply != null && tile.setCamoAndUpdate(stateToApply)) {
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isCrouching() && tile.getHeldState() != null) {
                tile.setCamoAndUpdate(null);
                return ItemInteractionResult.SUCCESS;
            }
            this.openMenu(player, (ElevatorBlockEntityBase)((Object)tile), pos);
            return ItemInteractionResult.SUCCESS;
        }).orElse(ItemInteractionResult.FAIL);
    }

    public static BlockBehaviour.StateArgumentPredicate<EntityType<?>> isValidSpawn(Supplier<BlockEntityType<? extends ElevatorBlockEntityBase>> tileType) {
        return (state, world, pos, entityType) -> (Boolean)Config.GENERAL.mobSpawn.get() != false && world.getBlockEntity(pos, (BlockEntityType)tileType.get()).map(ElevatorBlockEntityBase::getHeldState).map(s -> s.isValidSpawn(world, pos, entityType)).orElse(state.isFaceSturdy(world, pos, Direction.UP)) != false;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getHeldState(worldIn, pos).map(s -> s.getCollisionShape(worldIn, pos, context)).orElse(super.getCollisionShape(state, worldIn, pos, context));
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return this.getHeldState(world, pos).map(s -> s.isCollisionShapeFullBlock(world, pos)).orElse(super.isCollisionShapeFullBlock(state, world, pos));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getHeldState(worldIn, pos).map(s -> s.getShape(worldIn, pos, context)).orElse(super.getShape(state, worldIn, pos, context));
    }

    public float getSpeedFactor() {
        return super.getSpeedFactor();
    }

    public float getJumpFactor() {
        return super.getJumpFactor();
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        this.getElevatorTile((BlockGetter)worldIn, currentPos).ifPresent(t -> {
            if (t.getHeldState() == null) {
                return;
            }
            BlockState appearance = this.getAppearance(facingState, worldIn, facingPos, facing, t.getHeldState(), currentPos);
            BlockState updatedState = t.getHeldState().updateShape(facing, appearance, worldIn, currentPos, facingPos);
            if (!updatedState.equals(t.getHeldState())) {
                t.setHeldState(updatedState);
            }
        });
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected abstract BlockState getAppearance(BlockState var1, LevelAccessor var2, BlockPos var3, Direction var4, BlockState var5, BlockPos var6);

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter reader, BlockPos pos, Direction direction) {
        return this.getHeldState(reader, pos).map(s -> s.getSignal(reader, pos, direction)).orElse(super.getSignal(state, reader, pos, direction));
    }

    public int getDirectSignal(BlockState state, BlockGetter reader, BlockPos pos, Direction direction) {
        return this.getHeldState(reader, pos).map(s -> s.getDirectSignal(reader, pos, direction)).orElse(super.getDirectSignal(state, reader, pos, direction));
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.getHeldState(worldIn, pos).map(s -> s.getLightBlock(worldIn, pos)).orElse(worldIn.getMaxLightLevel());
    }

    protected float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.getHeldState(blockGetter, blockPos).map(s -> Float.valueOf(s.getShadeBrightness(blockGetter, blockPos))).orElse(Float.valueOf(super.getShadeBrightness(blockState, blockGetter, blockPos))).floatValue();
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return this.getHeldState(world, pos).map(s -> s.getOcclusionShape(world, pos)).orElse(super.getOcclusionShape(state, world, pos));
    }

    public DyeColor getColor() {
        return this.dyeColor;
    }

    private Optional<? extends ElevatorBlockEntityBase> getElevatorTile(BlockGetter world, BlockPos pos) {
        if (world == null || pos == null) {
            return Optional.empty();
        }
        return world.getBlockEntity(pos, this.tileEntityType.get());
    }

    protected Optional<BlockState> getHeldState(BlockGetter world, BlockPos pos) {
        return this.getElevatorTile(world, pos).map(ElevatorBlockEntityBase::getHeldState);
    }
}

