/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.tree.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.razordevs.deep_aether.world.feature.tree.foliage.DAFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class RoserootFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<RoserootFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(p2 -> RoserootFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)p2).and((App)IntProvider.codec((int)0, (int)24).fieldOf("trunk_height").forGetter(foliagePlacer -> foliagePlacer.trunkHeight)).apply((Applicative)p2, RoserootFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public RoserootFoliagePlacer(IntProvider intProvider, IntProvider intProvider1, IntProvider intProvider2) {
        super(intProvider, intProvider1);
        this.trunkHeight = intProvider2;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)DAFoliagePlacers.ROSEROOT_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int i1, FoliagePlacer.FoliageAttachment foliageAttachment, int foliageMaxHeight, int i2, int i3) {
        BlockPos blockpos = foliageAttachment.pos();
        for (int l = randomSource.nextInt(1, 4); l >= 0; --l) {
            this.placeLeavesRow(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockpos.above(1 + l), 0, 1, foliageAttachment.doubleTrunk());
        }
        int a1 = foliageMaxHeight / 3 * 2 + randomSource.nextInt(-1, 1);
        int a2 = foliageMaxHeight / 3 + randomSource.nextInt(-1, 1);
        for (int l = foliageMaxHeight; l >= 0; --l) {
            if (l == 0) {
                this.placeLeavesRow(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockpos, 1, 1, foliageAttachment.doubleTrunk());
                blockpos = blockpos.below(1);
                continue;
            }
            if (l >= a1) {
                this.placeSmallCircle(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockpos, foliageAttachment);
                blockpos = blockpos.below(1);
                continue;
            }
            if (l >= a2) {
                this.placeSquare(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockpos);
                blockpos = blockpos.below(1);
                continue;
            }
            this.placeBiggerCircle(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockpos, foliageAttachment);
            blockpos = blockpos.below(1);
        }
    }

    public void placeSquare(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, BlockPos blockpos) {
        for (int i = 0; i < 3; ++i) {
            for (int ii = 0; ii < 3; ++ii) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(i - 1).east(ii - 1).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(0).east(2).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(0).east(-2).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(2).east(0).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-2).east(0).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(1).east(2).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(1).east(-2).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-1).east(2).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-1).east(-2).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(2).east(1).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-2).east(1).above(2));
            }
            if (randomSource.nextInt(4) == 1) {
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(2).east(-1).above(2));
            }
            if (randomSource.nextInt(4) != 1) continue;
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-2).east(-1).above(2));
        }
    }

    public void placeSmallCircle(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, BlockPos blockpos, FoliagePlacer.FoliageAttachment foliageAttachment) {
        this.placeLeavesRow(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockpos, 1, 2, foliageAttachment.doubleTrunk());
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-1).east(-1).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(1).east(1).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(0).east(2).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(0).east(-2).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(2).east(0).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-2).east(0).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-1).east(1).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(1).east(-1).above(2));
        }
    }

    public void placeBiggerCircle(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, BlockPos blockpos, FoliagePlacer.FoliageAttachment foliageAttachment) {
        this.placeLeavesRow(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockpos, 2, 2, foliageAttachment.doubleTrunk());
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(0).east(3).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(0).east(-3).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(3).east(0).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-3).east(0).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(2).east(2).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-2).east(-2).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(2).east(-2).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-2).east(2).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(1).east(3).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-1).east(3).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(1).east(-3).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-1).east(-3).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(3).east(1).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(3).east(-1).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-3).east(1).above(2));
        }
        if (randomSource.nextBoolean()) {
            RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)blockpos.north(-3).east(-1).above(2));
        }
    }

    public int foliageHeight(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return Math.max(4, i - this.trunkHeight.sample(randomSource));
    }

    protected boolean shouldSkipLocation(RandomSource randomSource, int a, int b, int c, int d, boolean b1) {
        return a == d && c == d && d > 0;
    }

    protected void placeLeavesRow(LevelSimulatedReader simulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration configuration, BlockPos blockPos, int i1, int i2, boolean b) {
        int i = b ? 1 : 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = -i1; j <= i1 + i; ++j) {
            for (int k = -i1; k <= i1 + i; ++k) {
                if (this.shouldSkipLocationSigned(randomSource, j, i2, k, i1, b)) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockPos, j, i2, k);
                RoserootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)simulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)configuration, (BlockPos)blockpos$mutableblockpos);
            }
        }
    }
}

