/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.features;

import com.aetherteam.aether.block.AetherBlocks;
import com.mojang.serialization.Codec;
import io.github.razordevs.deep_aether.datagen.tags.DATags;
import io.github.razordevs.deep_aether.init.DABlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class TotemFeature
extends Feature<NoneFeatureConfiguration> {
    private static int excludedValue = 0;

    public TotemFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel reader = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        int height = rand.nextInt(2, 4);
        Direction direction = TotemFeature.getRandomDirectionYExcluded(rand);
        if ((!this.canPlace((LevelReader)reader, pos) || this.canPlace((LevelReader)reader, pos.below())) && rand.nextBoolean()) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            if (!this.canPlace((LevelReader)reader, pos)) continue;
            this.setBlock((LevelWriter)reader, pos, (BlockState)this.getRandomTotem(rand, false).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
            pos = pos.above();
        }
        return true;
    }

    public boolean canPlace(LevelReader reader, BlockPos pos) {
        BlockState state = reader.getBlockState(pos);
        BlockState below = reader.getBlockState(pos.below());
        return !(!reader.isEmptyBlock(pos) && !state.is(BlockTags.LEAVES) && !state.canBeReplaced() && state.isCollisionShapeFullBlock((BlockGetter)reader, pos) || !below.is((Holder)AetherBlocks.AETHER_GRASS_BLOCK) && !below.is(DATags.Blocks.TOTEMS));
    }

    public Block getRandomTotem(RandomSource random, boolean log) {
        return switch (this.randomNonRepeatedInteger(random, 4)) {
            case 0 -> (Block)DABlocks.MOA_TOTEM.get();
            case 1 -> (Block)DABlocks.ZEPHYR_TOTEM.get();
            case 2 -> (Block)DABlocks.AERWHALE_TOTEM.get();
            default -> log ? (Block)AetherBlocks.SKYROOT_LOG.get() : (Block)DABlocks.ZEPHYR_TOTEM.get();
        };
    }

    public static Direction getRandomDirectionYExcluded(RandomSource random) {
        return switch (random.nextInt(4)) {
            case 0 -> Direction.NORTH;
            case 1 -> Direction.SOUTH;
            case 2 -> Direction.EAST;
            default -> Direction.WEST;
        };
    }

    private int randomNonRepeatedInteger(RandomSource random, int bound) {
        int choice;
        while ((choice = random.nextInt(bound)) == excludedValue) {
        }
        excludedValue = choice;
        return choice;
    }
}

