/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.features;

import com.aetherteam.aether.block.AetherBlocks;
import com.mojang.serialization.Codec;
import io.github.razordevs.deep_aether.init.DABlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class RockSpikeFeature
extends Feature<NoneFeatureConfiguration> {
    public RockSpikeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int l;
        int k;
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        WorldGenLevel worldgenlevel = context.level();
        while (worldgenlevel.isEmptyBlock(blockpos) && blockpos.getY() > worldgenlevel.getMinBuildHeight() + 2) {
            blockpos = blockpos.below();
        }
        if (!worldgenlevel.getBlockState(blockpos).is((Block)DABlocks.HIGHSTONE.get())) {
            return false;
        }
        blockpos = blockpos.above(randomsource.nextInt(4));
        int i = randomsource.nextInt(4) + 7;
        int j = i / 4 + randomsource.nextInt(2);
        if (j > 1 && randomsource.nextInt(60) == 0) {
            blockpos = blockpos.above(10 + randomsource.nextInt(30));
        }
        for (k = 0; k < i; ++k) {
            float f = (1.0f - (float)k / (float)i) * (float)j;
            l = Mth.ceil((float)f);
            for (int i1 = -l; i1 <= l; ++i1) {
                float f1 = (float)Mth.abs((int)i1) - 0.25f;
                for (int j1 = -l; j1 <= l; ++j1) {
                    float f2 = (float)Mth.abs((int)j1) - 0.25f;
                    if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > f * f || (i1 == -l || i1 == l || j1 == -l || j1 == l) && randomsource.nextFloat() > 0.75f) continue;
                    BlockState blockstate = worldgenlevel.getBlockState(blockpos.offset(i1, k, j1));
                    if (blockstate.isAir() || RockSpikeFeature.isDirt((BlockState)blockstate) || blockstate.is((Block)DABlocks.RAW_CLORITE.get()) || blockstate.is((Block)AetherBlocks.HOLYSTONE.get()) || blockstate.is((Block)DABlocks.HIGHSTONE.get())) {
                        this.setBlock((LevelWriter)worldgenlevel, blockpos.offset(i1, k, j1), ((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState());
                    }
                    if (k == 0 || l <= 1 || !(blockstate = worldgenlevel.getBlockState(blockpos.offset(i1, -k, j1))).isAir() && !RockSpikeFeature.isDirt((BlockState)blockstate) && !blockstate.is((Block)DABlocks.RAW_CLORITE.get()) && !blockstate.is((Block)AetherBlocks.HOLYSTONE.get()) && !blockstate.is((Block)DABlocks.HIGHSTONE.get())) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.offset(i1, -k, j1), ((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState());
                }
            }
        }
        k = j - 1;
        if (k < 0) {
            k = 0;
        } else if (k > 1) {
            k = 1;
        }
        for (int l1 = -k; l1 <= k; ++l1) {
            for (l = -k; l <= k; ++l) {
                BlockState blockstate1;
                BlockPos blockpos1 = blockpos.offset(l1, -1, l);
                int j2 = 50;
                if (Math.abs(l1) == 1 && Math.abs(l) == 1) {
                    j2 = randomsource.nextInt(5);
                }
                while (blockpos1.getY() > 50 && ((blockstate1 = worldgenlevel.getBlockState(blockpos1)).isAir() || RockSpikeFeature.isDirt((BlockState)blockstate1) || blockstate1.is((Block)DABlocks.RAW_CLORITE.get())) && blockstate1.is((Block)AetherBlocks.HOLYSTONE.get()) && blockstate1.is((Block)DABlocks.HIGHSTONE.get())) {
                    this.setBlock((LevelWriter)worldgenlevel, blockpos1, ((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState());
                    blockpos1 = blockpos1.below();
                    if (--j2 > 0) continue;
                    blockpos1 = blockpos1.below(randomsource.nextInt(5) + 1);
                    j2 = randomsource.nextInt(5);
                }
            }
        }
        return true;
    }
}

