/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureUtil {
    public static List<ResourceLocation> getAvailableStructureList(Level level) {
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>();
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        registry.keySet().forEach(location -> {
            if (!structureList.contains(location)) {
                structureList.add((ResourceLocation)location);
            }
        });
        return structureList;
    }

    public static Pair<BlockPos, Holder<Structure>> findNearestMapStructure(ServerLevel serverLevel, HolderSet<Structure> structureHolderSet, BlockPos pos, int range, boolean findUnexplored) {
        ChunkGenerator generator = serverLevel.getChunkSource().getGenerator();
        Pair nearest = generator.findNearestMapStructure(serverLevel, structureHolderSet, pos, range, findUnexplored);
        if (nearest == null) {
            return null;
        }
        return ((BlockPos)nearest.getFirst()).distManhattan((Vec3i)pos) <= 5000 ? nearest : null;
    }
}

