/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.recipe;

import io.github.razordevs.deep_aether.init.DAItems;
import io.github.razordevs.deep_aether.item.component.DADataComponentTypes;
import io.github.razordevs.deep_aether.item.component.FloatyScarf;
import io.github.razordevs.deep_aether.recipe.DARecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class FloatyScarfColoring
extends CustomRecipe {
    public FloatyScarfColoring(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput input, @NotNull Level level) {
        boolean containsScarf = false;
        boolean containsBucket = false;
        int colorCount = 0;
        for (int k = 0; k < input.size(); ++k) {
            ItemStack itemstack = input.getItem(k);
            if (itemstack.is(DAItems.FLOATY_SCARF)) {
                containsScarf = true;
                continue;
            }
            if (itemstack.getItem() instanceof DyeItem) {
                ++colorCount;
                continue;
            }
            if (itemstack.is(Tags.Items.BUCKETS)) {
                if (containsBucket) {
                    return false;
                }
                containsBucket = true;
                continue;
            }
            if (itemstack.isEmpty()) continue;
            return false;
        }
        if (containsBucket && colorCount > 0) {
            return false;
        }
        return containsScarf;
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        FloatyScarf floatyScarf;
        ArrayList<Integer> colors = new ArrayList<Integer>();
        ItemStack scarf = new ItemStack((ItemLike)DAItems.FLOATY_SCARF.get());
        boolean bucket = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemstack = input.getItem(i);
            if (itemstack.is(DAItems.FLOATY_SCARF)) {
                scarf = itemstack;
                continue;
            }
            Item item = itemstack.getItem();
            if (item instanceof DyeItem) {
                DyeItem item2 = (DyeItem)item;
                colors.add(item2.getDyeColor().getTextureDiffuseColor());
                continue;
            }
            if (!itemstack.is(Items.WATER_BUCKET)) continue;
            bucket = true;
            break;
        }
        if ((floatyScarf = (FloatyScarf)(scarf = scarf.copy()).get(DADataComponentTypes.FLOATY_SCARF)) == null) {
            floatyScarf = FloatyScarf.withDefaultColor(0);
        }
        if (bucket) {
            List<Integer> colors1 = floatyScarf.colors();
            colors1.set(floatyScarf.currentModification(), -1);
            byte currentModification = (byte)(floatyScarf.currentModification() + 1);
            if (currentModification > 4) {
                currentModification = 0;
            }
            floatyScarf = new FloatyScarf(floatyScarf.uuid(), colors1, currentModification);
        } else if (colors.isEmpty()) {
            byte currentModification = (byte)(floatyScarf.currentModification() + 1);
            if (currentModification > 4) {
                currentModification = 0;
            }
            floatyScarf = new FloatyScarf(floatyScarf.uuid(), floatyScarf.colors(), currentModification);
        } else {
            int applyDyes = FloatyScarfColoring.applyDyes(floatyScarf.colors().get(floatyScarf.currentModification()), colors);
            List<Integer> colors1 = floatyScarf.colors();
            colors1.set(floatyScarf.currentModification(), applyDyes);
            byte currentModification = (byte)(floatyScarf.currentModification() + 1);
            if (currentModification > 4) {
                currentModification = 0;
            }
            floatyScarf = new FloatyScarf(floatyScarf.uuid(), colors1, currentModification);
        }
        scarf.set(DADataComponentTypes.FLOATY_SCARF, (Object)floatyScarf);
        return scarf.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)DARecipeSerializers.FLOATY_SCARF_COLORING.get();
    }

    public static int applyDyes(int color, List<Integer> dyes) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        int i1 = 0;
        int j1 = FastColor.ARGB32.red((int)color);
        int k1 = FastColor.ARGB32.green((int)color);
        int l1 = FastColor.ARGB32.blue((int)color);
        l += Math.max(j1, Math.max(k1, l1));
        i += j1;
        j += k1;
        k += l1;
        ++i1;
        for (int dye : dyes) {
            int i2 = FastColor.ARGB32.red((int)dye);
            int j2 = FastColor.ARGB32.green((int)dye);
            int k2 = FastColor.ARGB32.blue((int)dye);
            l += Math.max(i2, Math.max(j2, k2));
            i += i2;
            j += j2;
            k += k2;
            ++i1;
        }
        int l2 = i / i1;
        int i3 = j / i1;
        int k3 = k / i1;
        float f = (float)l / (float)i1;
        float f1 = Math.max(l2, Math.max(i3, k3));
        l2 = (int)((float)l2 * f / f1);
        i3 = (int)((float)i3 * f / f1);
        k3 = (int)((float)k3 * f / f1);
        return FastColor.ARGB32.color((int)0, (int)l2, (int)i3, (int)k3);
    }
}

