/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.gear.stratus;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import io.github.razordevs.deep_aether.DeepAetherConfig;
import io.github.razordevs.deep_aether.client.DeepAetherKeys;
import io.github.razordevs.deep_aether.item.gear.DAEquipmentUtil;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StratusAbility
extends ArmorItem {
    public static float coolDown = 0.0f;
    private static boolean hasBeenOnGround = true;

    public StratusAbility(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(armorMaterial, type, properties);
    }

    private static boolean isStratusDashActive(Player player) {
        return DAEquipmentUtil.hasFullStratusSet((LivingEntity)player) && coolDown <= 0.0f;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.onGround()) {
                hasBeenOnGround = true;
            }
            if (coolDown >= 0.0f) {
                coolDown -= 0.02f;
            }
            if (level.isClientSide() && DAEquipmentUtil.hasFullStratusSet((LivingEntity)player) && DeepAetherKeys.STRATUS_DASH_ABILITY.isDown()) {
                StratusAbility.dash((LivingEntity)player);
            }
        }
    }

    static void dash(LivingEntity entity) {
        if (DAEquipmentUtil.hasFullStratusSet(entity) && hasBeenOnGround && entity instanceof Player) {
            Player player = (Player)entity;
            double x = player.getLookAngle().x * 1.3 * 2.0;
            double y = player.getLookAngle().y * 1.3;
            double z = player.getLookAngle().z * 1.3 * 2.0;
            double a = Math.abs(y * 0.5);
            a = 1.0 - a;
            if (StratusAbility.isStratusDashActive(player)) {
                hasBeenOnGround = false;
                coolDown = ((Integer)DeepAetherConfig.SERVER.stratus_dash_cooldown.get()).intValue();
                float dashMultiplier = (float)DAEquipmentUtil.handleStratusRingBoost((LivingEntity)player);
                player.push(x * a * (double)dashMultiplier, y * (double)dashMultiplier, z * a * (double)dashMultiplier);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
            }
        }
    }

    public static void moreBoostedJump(LivingEntity entity) {
        if (DAEquipmentUtil.hasFullStratusSet(entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.hasData((Supplier)AetherDataAttachments.AETHER_PLAYER) && ((AetherPlayerAttachment)player.getData((Supplier)AetherDataAttachments.AETHER_PLAYER)).isGravititeJumpActive()) {
                    player.push(0.0, 1.3 * (double)((float)DAEquipmentUtil.handleStratusRingBoost((LivingEntity)player)), 0.0);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                    }
                }
            } else {
                entity.push(0.0, 1.3, 0.0);
            }
        }
    }
}

