/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.gear.other;

import io.github.razordevs.deep_aether.entity.projectile.FireProjectile;
import io.github.razordevs.deep_aether.init.DASounds;
import io.github.razordevs.deep_aether.init.DATiers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class Afterburner
extends TieredItem {
    public Afterburner(Item.Properties properties) {
        super((Tier)DATiers.FIRE, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack heldStack = player.getItemInHand(interactionHand);
        if (!level.isClientSide()) {
            player.startUsingItem(interactionHand);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)heldStack);
        }
        return InteractionResultHolder.fail((Object)heldStack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack itemStack, int i) {
        Player player = (Player)livingEntity;
        if (player.getTicksUsingItem() > 20 && itemStack.getMaxDamage() > itemStack.getDamageValue()) {
            FireProjectile fireProjectile = new FireProjectile((LivingEntity)player, level);
            fireProjectile.shoot(player.getXRot(), player.getYRot(), 1.0f, 10.0f);
            level.addFreshEntity((Entity)fireProjectile);
            level.playLocalSound(player.getX(), player.getY(), player.getZ(), (SoundEvent)DASounds.ITEM_AFTERBURNER_FIRES.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (livingEntity.getRandom().nextFloat() * 0.4f + 0.8f), false);
        }
        super.onUseTick(level, livingEntity, itemStack, i);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (count < stack.getUseDuration(entity) - 20 && stack.getMaxDamage() > stack.getDamageValue() && !player.isCreative()) {
                player.getCooldowns().addCooldown((Item)this, 60);
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            }
        }
        super.onStopUsing(stack, entity, count);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 60;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }
}

