/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.dungeon.brass;

import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.item.accessories.SlotIdentifierHolder;
import com.aetherteam.aether.item.accessories.miscellaneous.ShieldOfRepulsionItem;
import io.github.razordevs.deep_aether.networking.attachment.DAAttachments;
import io.github.razordevs.deep_aether.networking.attachment.DAPlayerAttachment;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WindShieldItem
extends AccessoryItem
implements SlotIdentifierHolder {
    private static final ResourceLocation SHIELD_OF_REPULSION = ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"textures/models/accessory/wind_shield/wind_shield_accessory.png");

    public WindShieldItem(Item.Properties properties) {
        super(properties);
    }

    public WindShieldItem(Holder<SoundEvent> soundEventSupplier, Item.Properties properties) {
        super(soundEventSupplier, properties);
    }

    public ResourceLocation getWindShieldTexture() {
        return SHIELD_OF_REPULSION;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        Player player;
        DAPlayerAttachment attachment;
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof Player && (attachment = (DAPlayerAttachment)(player = (Player)livingEntity).getData(DAAttachments.PLAYER)).getWindShieldCooldown() > 0) {
            ((DAPlayerAttachment)player.getData(DAAttachments.PLAYER)).setWindShieldCooldown(attachment.getWindShieldCooldown() - 1);
        }
        super.tick(stack, reference);
    }

    public SlotTypeReference getIdentifier() {
        return ShieldOfRepulsionItem.getStaticIdentifier();
    }
}

