/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.dungeon.brass;

import com.aetherteam.aether.item.EquipmentUtil;
import io.github.razordevs.deep_aether.init.DAItems;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="deep_aether")
public class StormSwordItem
extends SwordItem {
    public StormSwordItem(Tier pTier, Item.Properties pProperties) {
        super(pTier, pProperties);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Post event) {
        DamageSource damageSource = event.getEntity().getLastDamageSource();
        if (damageSource == null) {
            return;
        }
        if (StormSwordItem.canPerformAbility(damageSource) && damageSource.getEntity() != null) {
            LivingEntity target = event.getEntity();
            Entity attacker = damageSource.getEntity();
            target.knockback(1.5, (double)Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)))));
        }
    }

    private static boolean canPerformAbility(DamageSource source) {
        LivingEntity attacker;
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity && EquipmentUtil.isFullStrength((LivingEntity)(attacker = (LivingEntity)entity))) {
            return attacker.getMainHandItem().is((Item)DAItems.STORM_SWORD.get());
        }
        return false;
    }
}

