/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.dungeon.brass;

import com.aetherteam.aether.item.accessories.cape.CapeItem;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CloudCapeItem
extends CapeItem {
    boolean hasDoubleJumped = false;
    boolean canJump = false;

    public CloudCapeItem(ResourceLocation capeLocation, Item.Properties properties) {
        super(capeLocation, properties);
    }

    public void tick(ItemStack stack, SlotReference reference) {
        if (reference.entity().level().isClientSide()) {
            if (reference.entity().onGround()) {
                this.hasDoubleJumped = false;
                this.canJump = false;
            } else if (!this.canJump) {
                this.canJump = !Minecraft.getInstance().options.keyJump.isDown();
            } else if (!this.hasDoubleJumped && Minecraft.getInstance().options.keyJump.isDown()) {
                this.hasDoubleJumped = true;
                reference.entity().setDeltaMovement(reference.entity().getDeltaMovement().x(), 0.42, reference.entity().getDeltaMovement().z());
                reference.entity().resetFallDistance();
                LivingEntity livingEntity = reference.entity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
            }
        }
    }
}

