/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item;

import io.github.razordevs.deep_aether.DeepAether;
import io.github.razordevs.deep_aether.init.DAItems;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class DATrimMaterials {
    public static final ResourceKey<TrimMaterial> STORMFORGED = DATrimMaterials.createKey("stormforged");

    private static ResourceKey<TrimMaterial> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)DeepAether.getResource(name));
    }

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        DATrimMaterials.register(context, STORMFORGED, (Item)DAItems.SQUALL_PLATE.get(), Style.EMPTY.withColor(13163998), 0.9f);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item ingredient, Style style, float itemModelIndex) {
        DATrimMaterials.register(context, materialKey, ingredient, style, itemModelIndex, Map.of());
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item ingredient, Style style, float itemModelIndex, Map<Holder<ArmorMaterial>, String> overrideArmorMaterials) {
        TrimMaterial trimMaterial = TrimMaterial.create((String)materialKey.location().getPath(), (Item)ingredient, (float)itemModelIndex, (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)materialKey.location())).withStyle(style), overrideArmorMaterials);
        context.register(materialKey, (Object)trimMaterial);
    }
}

