/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.event;

import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.event.BossFightEvent;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import io.github.razordevs.deep_aether.DeepAether;
import io.github.razordevs.deep_aether.DeepAetherConfig;
import io.github.razordevs.deep_aether.advancement.DAAdvancementTriggers;
import io.github.razordevs.deep_aether.datagen.tags.DATags;
import io.github.razordevs.deep_aether.init.DAItems;
import io.github.razordevs.deep_aether.init.DAMobEffects;
import io.github.razordevs.deep_aether.item.gear.DAEquipmentUtil;
import io.github.razordevs.deep_aether.item.gear.other.FloatyScarfItem;
import io.github.razordevs.deep_aether.item.gear.skyjade.SkyjadeWeapon;
import io.github.razordevs.deep_aether.networking.attachment.DAAttachments;
import io.github.razordevs.deep_aether.networking.attachment.DAPlayerAttachment;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="deep_aether")
public class DAGeneralEvents {
    public static final HashMap<EntityType<?>, Item> FLAWLESS_BOSS_DROP = new HashMap();
    private static int i = 0;

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ((DAPlayerAttachment)player.getData(DAAttachments.PLAYER)).onJoinLevel(player);
        }
    }

    @SubscribeEvent
    public static void playerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        SlotEntryReference reference = DAEquipmentUtil.getFloatyScarf((LivingEntity)player);
        if (reference != null) {
            FloatyScarfItem.discardGentleWind(reference.stack(), player.level());
        }
    }

    @SubscribeEvent
    public static void onDungeonPlayerAdded(BossFightEvent.AddPlayer event) {
        event.getPlayer().setData((AttachmentType)DAAttachments.PLAYER_BOSS_FIGHT.get(), (Object)false);
    }

    @SubscribeEvent
    public static void onLivingEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getType() == AetherEntityTypes.SLIDER.get() && DeepAether.IsHalloweenContentEnabled()) {
            entity.spawnAtLocation(new ItemStack((ItemLike)DAItems.SPOOKY_RING.get(), 1));
        }
        if (entity instanceof AetherBossMob) {
            AetherBossMob bossMob = (AetherBossMob)entity;
            Level level = entity.level();
            if (!event.getEntity().isAlive() && !level.isClientSide() && bossMob.getDungeon() != null) {
                List uuids = bossMob.getDungeon().dungeonPlayers();
                ArrayList<Player> players = new ArrayList<Player>();
                for (UUID uuid : uuids) {
                    Player player = level.getPlayerByUUID(uuid);
                    if (player == null) continue;
                    if (((Boolean)player.getData(DAAttachments.PLAYER_BOSS_FIGHT)).booleanValue()) {
                        return;
                    }
                    players.add(player);
                }
                for (Player player : players) {
                    ((KilledTrigger)DAAdvancementTriggers.FLAWLESS_TRIGGER.get()).trigger((ServerPlayer)player, (Entity)entity, event.getSource());
                }
                if (FLAWLESS_BOSS_DROP.get(entity.getType()) != null) {
                    ItemStack stack = new ItemStack((ItemLike)FLAWLESS_BOSS_DROP.get(entity.getType()));
                    ItemEntity itementity = new ItemEntity(level, entity.getX(), entity.getY() + 0.0, entity.getZ(), stack);
                    itementity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itementity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void applyValkyrieValorRes(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity undead = (LivingEntity)entity;
            if (event.getEntity().hasEffect(DAMobEffects.VALKYRIE_VALOR) && !event.getSource().is(DamageTypeTags.BYPASSES_RESISTANCE) && undead.getType().is(EntityTypeTags.UNDEAD)) {
                int j = 10;
                float f = event.getNewDamage() * (float)j;
                float f1 = event.getNewDamage();
                event.setNewDamage(Math.max(f / 25.0f, 0.0f));
                float f2 = f1 - event.getNewDamage();
                if (f2 > 0.0f && f2 < 3.4028235E37f) {
                    LivingEntity livingEntity = event.getEntity();
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)livingEntity;
                        player.awardStat(Stats.CUSTOM.get((Object)Stats.DAMAGE_RESISTED), Math.round(f2 * 10.0f));
                    } else {
                        livingEntity = event.getSource().getEntity();
                        if (livingEntity instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)livingEntity;
                            player.awardStat(Stats.CUSTOM.get((Object)Stats.DAMAGE_DEALT_RESISTED), Math.round(f2 * 10.0f));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingIncomingDamageEvent(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DAPlayerAttachment attachment = (DAPlayerAttachment)player.getData(DAAttachments.PLAYER);
            Optional stack = EquipmentUtil.findFirstAccessory((LivingEntity)player, (Item)((Item)DAItems.WIND_SHIELD.get()));
            if (stack.isPresent() && !event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) && attachment.getWindShieldCooldown() <= 0 && DAEquipmentUtil.hasWindShield((LivingEntity)player)) {
                ((DAPlayerAttachment)player.getData(DAAttachments.PLAYER)).setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "setWindShieldCooldown", 1200);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.level().isClientSide()) {
                    ((SlotEntryReference)stack.get()).stack().hurtAndBreak(1, (ServerLevel)player.level(), (LivingEntity)player, item -> {});
                    player.invulnerableTime = 20;
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityHurt(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!event.getEntity().isDamageSourceBlocked(event.getSource())) {
                player.setData(DAAttachments.PLAYER_BOSS_FIGHT, (Object)true);
            }
        }
        if (event.getSource().getDirectEntity() != null && (livingEntity = event.getSource().getDirectEntity()) instanceof LivingEntity) {
            LivingEntity target = livingEntity;
            if (DAEquipmentUtil.hasFullStormforgedSet(event.getEntity())) {
                target.knockback(0.5, event.getEntity().getX() - target.getX(), event.getEntity().getZ() - target.getZ());
                if (target instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity;
        if (((Boolean)DeepAetherConfig.SERVER.enable_skyjade_rework.get()).booleanValue() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            DAPlayerAttachment attachment = (DAPlayerAttachment)player.getData(DAAttachments.PLAYER);
            boolean skyjade = DAEquipmentUtil.hasFullSkyjadeSet((LivingEntity)player);
            boolean enabled = attachment.isSkyjadeAbilityActivated();
            attachment.setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "hasSkyjadeSet", skyjade);
            DAEquipmentUtil.updateSkyjadeBehavior(player, skyjade && enabled);
        }
    }

    @SubscribeEvent
    public static void livingVisibilityModification(LivingEvent.LivingVisibilityEvent event) {
        Entity entity;
        if (((Boolean)DeepAetherConfig.SERVER.enable_skyjade_rework.get()).booleanValue() && (entity = event.getLookingEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            boolean enabled = true;
            if (living instanceof Player) {
                Player player = (Player)living;
                enabled = ((DAPlayerAttachment)player.getData(DAAttachments.PLAYER)).isSkyjadeAbilityActivated();
            }
            if (enabled && DAEquipmentUtil.hasFullSkyjadeSet(living)) {
                event.modifyVisibility(event.getVisibilityModifier() * 0.5);
            }
        }
    }

    @SubscribeEvent
    public static void onModifyAttributes(ItemAttributeModifierEvent event) {
        ItemAttributeModifiers modifiers = event.getDefaultModifiers();
        ItemStack itemStack = event.getItemStack();
        Item var4 = itemStack.getItem();
        if (var4 instanceof SkyjadeWeapon) {
            SkyjadeWeapon zaniteWeapon = (SkyjadeWeapon)var4;
            ItemAttributeModifiers.Entry attributeEntry = zaniteWeapon.increaseDamage(modifiers, itemStack);
            event.replaceModifier(attributeEntry.attribute(), attributeEntry.modifier(), attributeEntry.slot());
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(EntityTickEvent.Post event) {
        if (event.getEntity().hasData(DAAttachments.PLAYER)) {
            ((DAPlayerAttachment)event.getEntity().getData(DAAttachments.PLAYER)).onUpdate((Player)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ((DAPlayerAttachment)event.getEntity().getData(DAAttachments.PLAYER)).onLogin(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTooltipAdd(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        TooltipFlag flag = event.getFlags();
        List itemTooltips = event.getToolTip();
        if (flag.isCreative()) {
            int position = itemTooltips.size();
            Component itemName = stack.getItem().getName(stack);
            for (int i = 0; i < position; ++i) {
                Component component = (Component)itemTooltips.get(i);
                if (!component.getString().equals(itemName.getString())) continue;
                position = i + 1;
                break;
            }
            if (stack.is(DATags.Items.BRASS_DUNGEON_LOOT)) {
                itemTooltips.add(position, DAItems.BRASS_DUNGEON_TOOLTIP);
            }
        }
        if (stack.is(DATags.Items.FLAWLESS_ITEMS)) {
            DAGeneralEvents.flawlessComponent(itemTooltips, i);
            i = i < 80 ? i + 1 : 0;
        }
    }

    private static void flawlessComponent(List<Component> tagTooltips, int i) {
        if (i > 70) {
            DAGeneralEvents.printComponent(tagTooltips, 1);
        } else if (i > 60) {
            DAGeneralEvents.printComponent(tagTooltips, 2);
        } else if (i > 50) {
            DAGeneralEvents.printComponent(tagTooltips, 3);
        } else if (i > 40) {
            DAGeneralEvents.printComponent(tagTooltips, 4);
        } else if (i > 30) {
            DAGeneralEvents.printComponent(tagTooltips, 5);
        } else if (i > 20) {
            DAGeneralEvents.printComponent(tagTooltips, 6);
        } else if (i > 10) {
            DAGeneralEvents.printComponent(tagTooltips, 7);
        } else {
            DAGeneralEvents.printComponent(tagTooltips, 8);
        }
    }

    private static void printComponent(List<Component> tagTooltips, int i) {
        tagTooltips.add(1, (Component)Component.translatable((String)("gui.deep_aether.flawless_tier_" + i)));
    }
}

