/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.entity.projectile;

import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.network.packet.serverbound.HammerProjectileLaunchPacket;
import io.github.razordevs.deep_aether.init.DAEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class FireProjectile
extends ThrowableProjectile {
    private int ticksInAir = 0;

    public FireProjectile(EntityType<? extends FireProjectile> type, Level level) {
        super(type, level);
    }

    public FireProjectile(LivingEntity owner, Level level) {
        super((EntityType)DAEntities.FIRE_PROJECTILE.get(), owner, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (!this.onGround()) {
            ++this.ticksInAir;
        }
        if (this.ticksInAir > 50 && !this.level().isClientSide()) {
            this.discard();
        }
        if (this.level().isClientSide()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY() + 0.2, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public void shoot(float rotationPitch, float rotationYaw, float velocity, float inaccuracy) {
        float x = -Mth.sin((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(rotationPitch * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        super.shoot((double)x, (double)y, (double)z, velocity, inaccuracy);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity target = result.getEntity();
        if (!this.level().isClientSide()) {
            this.setTargetOnFire(target);
            this.level().broadcastEntityEvent((Entity)this, (byte)70);
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new HammerProjectileLaunchPacket(target.getId(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.spawnParticles();
        }
        if (target.hurt(AetherDamageTypes.indirectEntityDamageSource((Level)this.level(), (ResourceKey)DamageTypes.MOB_PROJECTILE, (Entity)this, (Entity)this.getOwner()), 10.0f)) {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        Entity entity;
        super.onHitBlock(result);
        if (!(this.level().isClientSide || this.level().dimension().equals(AetherDimensions.AETHER_LEVEL) || (entity = this.getOwner()) instanceof Mob && !EventHooks.canEntityGrief((Level)this.level(), (Entity)entity))) {
            BlockPos blockpos = result.getBlockPos().relative(result.getDirection());
            if (this.level().isEmptyBlock(blockpos)) {
                this.level().setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockpos));
            }
        }
    }

    private void spawnParticles() {
        for (int j = 0; j < 8; ++j) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public void setTargetOnFire(Entity target) {
        if (target != this.getOwner() && (this.getOwner() == null || target != this.getOwner().getVehicle()) && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.hurt(AetherDamageTypes.indirectEntityDamageSource((Level)this.level(), (ResourceKey)DamageTypes.ON_FIRE, (Entity)this, (Entity)this.getOwner()), 4.5f);
        }
    }

    protected double getDefaultGravity() {
        return 0.1f;
    }

    public void handleEntityEvent(byte id) {
        if (id == 70) {
            this.spawnParticles();
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("TicksInAir", this.ticksInAir);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("TicksInAir")) {
            this.ticksInAir = tag.getInt("TicksInAir");
        }
    }
}

