/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.entity.living;

import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import io.github.razordevs.deep_aether.entity.goals.FollowPlayerGoal;
import io.github.razordevs.deep_aether.entity.projectile.VenomiteBubble;
import io.github.razordevs.deep_aether.init.DAEntities;
import io.github.razordevs.deep_aether.init.DASounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Venomite
extends AetherAnimal
implements NeutralMob,
FlyingAnimal {
    public static final int TICKS_PER_FLAP = Mth.ceil((float)1.4959966f);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Venomite.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(Venomite.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int underWaterTicks;
    private float rollAmount;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;

    public Venomite(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.xpReward = 3;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public float getWalkTargetValue(BlockPos state, LevelReader blockState) {
        return blockState.getBlockState(state).isAir() ? 10.0f : 0.0f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new VenomiteAttackGoal((PathfinderMob)this, 1.4f, true));
        this.goalSelector.addGoal(1, (Goal)new FollowPlayerGoal((PathfinderMob)this, 1.0, 1.0));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new VenomiteHurtByOtherGoal(this).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new VenomiteBecomeAngryTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.addPersistentAngerSaveData(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.readPersistentAngerSaveData(this.level(), compoundTag);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)DASounds.VENOMITE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)DASounds.VENOMITE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)DASounds.VENOMITE_DEATH.get();
    }

    protected void checkFallDamage(double v, boolean b, BlockState blockState, BlockPos blockPos) {
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.setCanFloat(true);
        return flyingpathnavigation;
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return !effectInstance.getEffect().is((Holder)AetherEffects.INEBRIATION);
    }

    private boolean getFlag(int flag) {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & flag) != 0;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        return null;
    }

    public boolean isFlapping() {
        return this.isFlying() && this.tickCount % TICKS_PER_FLAP == 0;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int set) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)set);
    }

    @javax.annotation.Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@javax.annotation.Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f, 1.5f);
    }

    private void setFlag(int i, boolean b) {
        if (b) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS_ID) | i)));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS_ID) & ~i)));
        }
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (!this.level().isClientSide && this.isDeadOrDying() && this.random.nextBoolean()) {
            VenomiteBubble bubble = new VenomiteBubble((EntityType<? extends VenomiteBubble>)((EntityType)DAEntities.VENOMITE_BUBBLE.get()), this.level());
            bubble.moveTo(this.getPosition(0.0f));
            this.level().addFreshEntity((Entity)bubble);
        }
        super.remove(removalReason);
    }

    public void tick() {
        super.tick();
        this.updateRollAmount();
    }

    private void updateRollAmount() {
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    protected void customServerAiStep() {
        this.underWaterTicks = this.isInWaterOrBubble() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.hurt(this.damageSources().drown(), 1.0f);
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), false);
        }
    }

    private boolean isRolling() {
        return this.getFlag(2);
    }

    private void setRolling(boolean p_27930_) {
        this.setFlag(2, p_27930_);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            boolean flag = this.isAngry() && this.getTarget() != null && this.getTarget().distanceToSqr((Entity)this) < 4.0;
            this.setRolling(flag);
        }
    }

    class VenomiteAttackGoal
    extends MeleeAttackGoal {
        VenomiteAttackGoal(PathfinderMob mob, double v, boolean b) {
            super(mob, v, b);
        }

        public boolean canUse() {
            return super.canUse() && Venomite.this.isAngry();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && Venomite.this.isAngry();
        }
    }

    class VenomiteHurtByOtherGoal
    extends HurtByTargetGoal {
        VenomiteHurtByOtherGoal(Venomite venomite) {
            super((PathfinderMob)venomite, new Class[0]);
        }

        public boolean canContinueToUse() {
            return Venomite.this.isAngry() && super.canContinueToUse();
        }

        protected void alertOther(Mob mob, LivingEntity livingEntity) {
            if (mob instanceof Venomite && this.mob.hasLineOfSight((Entity)livingEntity)) {
                mob.setTarget(livingEntity);
            }
        }
    }

    static class VenomiteBecomeAngryTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        VenomiteBecomeAngryTargetGoal(Venomite venomite) {
            super((Mob)venomite, Player.class, 10, true, false, arg_0 -> ((Venomite)venomite).isAngryAt(arg_0));
        }

        public boolean canUse() {
            return this.venomiteCanTarget() && super.canUse();
        }

        public boolean canContinueToUse() {
            boolean flag = this.venomiteCanTarget();
            if (flag && this.mob.getTarget() != null) {
                return super.canContinueToUse();
            }
            this.targetMob = null;
            return false;
        }

        private boolean venomiteCanTarget() {
            Venomite venomite = (Venomite)this.mob;
            return venomite.isAngry();
        }
    }
}

