/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.datagen.registry;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.AetherFeatureRules;
import com.aetherteam.aether.data.resources.AetherFeatureStates;
import com.aetherteam.aether.data.resources.builders.AetherConfiguredFeatureBuilders;
import com.aetherteam.aether.world.configuration.AercloudConfiguration;
import com.aetherteam.aether.world.configuration.ShelfConfiguration;
import com.aetherteam.aether.world.feature.AetherFeatures;
import com.aetherteam.nitrogen.data.resources.builders.NitrogenConfiguredFeatureBuilders;
import com.google.common.collect.ImmutableList;
import io.github.razordevs.deep_aether.block.behavior.GoldenVines;
import io.github.razordevs.deep_aether.datagen.tags.DATags;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.world.feature.DAFeatureStates;
import io.github.razordevs.deep_aether.world.feature.DAFeatures;
import io.github.razordevs.deep_aether.world.feature.features.RootFeature;
import io.github.razordevs.deep_aether.world.feature.features.configuration.AercloudCloudConfiguration;
import io.github.razordevs.deep_aether.world.feature.features.configuration.DAHugeMushroomFeatureConfiguration;
import io.github.razordevs.deep_aether.world.feature.features.configuration.FallenTreeConfiguration;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.GlowingTrunkVineDecorator;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.GlowingVineDecorator;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.SunrootHangerDecorator;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.YagrootRootPlacer;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.YagrootVineDecorator;
import io.github.razordevs.deep_aether.world.feature.tree.foliage.RoserootFoliagePlacer;
import io.github.razordevs.deep_aether.world.feature.tree.foliage.YagrootFoliagePlacer;
import io.github.razordevs.deep_aether.world.feature.tree.trunk.SunrootTunkPlacer;
import io.github.razordevs.deep_aether.world.feature.tree.trunk.TwinTrunkPlacer;
import io.github.razordevs.deep_aether.world.feature.tree.trunk.YagrootTrunkPlacer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.MegaJungleFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.MangroveRootPlacement;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.MegaJungleTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.registries.DeferredBlock;

public class DAConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> POISON_LAKE_CONFIGURATION = DAConfiguredFeatures.createKey("poison_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POISON_SPRING_CONFIGURATION = DAConfiguredFeatures.createKey("poison_spring");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERCLOUD_LAKE_CONFIGURATION = DAConfiguredFeatures.createKey("aercloud_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YAGROOT_TREE_CONFIGURATION = DAConfiguredFeatures.createKey("yagroot_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CRUDEROOT_TREE_CONFIGURATION = DAConfiguredFeatures.createKey("cruderoot_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROSEROOT_AND_BLUE_ROSEROOT_TREES_PLACEMENT = DAConfiguredFeatures.createKey("roseroot_and_blue_roseroot_trees_placement");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YAGROOT_AND_CRUDEROOT_TREES_PLACEMENT = DAConfiguredFeatures.createKey("yagroot_and_cruderoot_trees_placement");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AETHER_MOSS_VEGETATION = DAConfiguredFeatures.createKey("aether_moss_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AETHER_MOSS_PATCH_BONEMEAL = DAConfiguredFeatures.createKey("aether_moss_patch_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_SKYJADE_CONFIGURATION = DAConfiguredFeatures.createKey("skyjade_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_MORE_SKYJADE_CONFIGURATION = DAConfiguredFeatures.createKey("more_skyjade_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASETERITE_CONFIGURATION = DAConfiguredFeatures.createKey("aseterite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CLORITE_CONFIGURATION = DAConfiguredFeatures.createKey("clorite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERLAVENDER_PATCH = DAConfiguredFeatures.createKey("aerlavender_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROSEROOT_TREE_LARGE = DAConfiguredFeatures.createKey("roseroot_tree_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROSEROOT_TREE_SMALL = DAConfiguredFeatures.createKey("roseroot_tree_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_AERGLOW_TREE = DAConfiguredFeatures.createKey("fallen_aerglow_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EMPTY_FALLEN_AERGLOW_TREE = DAConfiguredFeatures.createKey("empty_fallen_aerglow_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_ROSEROOT_TREE_LARGE = DAConfiguredFeatures.createKey("blue_roseroot_tree_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_ROSEROOT_TREE_SMALL = DAConfiguredFeatures.createKey("blue_roseroot_tree_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROSEROOT_FOREST_FLOWERS = DAConfiguredFeatures.createKey("roseroot_forest_flowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MYSTIC_ROSEROOT_FOREST_FLOWERS = DAConfiguredFeatures.createKey("mystic_roseroot_forest_flowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROSEROOT_FOREST_GRASS = DAConfiguredFeatures.createKey("roseroot_forest_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROSEROOT_TREES_PLACEMENT = DAConfiguredFeatures.createKey("roseroot_trees_placement");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_ROSEROOT_TREES_PLACEMENT = DAConfiguredFeatures.createKey("blue_roseroot_trees_placement");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AETHER_CATTAILS_PATCH = DAConfiguredFeatures.createKey("aether_cattails_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLDEN_GRASS_PATCH = DAConfiguredFeatures.createKey("golden_grass_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLDEN_GROVE_GRASS_PATCH = DAConfiguredFeatures.createKey("golden_grove_grass_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONBERRY_TREE = DAConfiguredFeatures.createKey("conberry_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUNROOT_TREE = DAConfiguredFeatures.createKey("sunroot_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLDEN_VINES_PATCH = DAConfiguredFeatures.createKey("golden_vines_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLDEN_GRASS_BLOCK_BONEMEAL_PATCH = DAConfiguredFeatures.createKey("golden_grass_block_bonemeal_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VIRULENT_QUICKSAND_PATCH = DAConfiguredFeatures.createKey("virulent_quicksand_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STERLING_AERCLOUD_CONFIGURATION = DAConfiguredFeatures.createKey("sterling_aercloud");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AETHER_COARSE_DIRT = DAConfiguredFeatures.createKey("aether_coarse_dirt");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AETHER_COARSE_DIRT_PATCH = DAConfiguredFeatures.createKey("aether_coarse_dirt_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SKY_TULIPS = DAConfiguredFeatures.createKey("sky_tulips");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GOLDEN_ASPESS = DAConfiguredFeatures.createKey("golden_aspess");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ECHAISY = DAConfiguredFeatures.createKey("echaisy");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_LIGHTCAP_MUSHROOM = DAConfiguredFeatures.createKey("huge_lightcap_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_PINK_AERCLOUD_MUSHROOM = DAConfiguredFeatures.createKey("huge_pink_aercloud_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_BLUE_AERCLOUD_MUSHROOM = DAConfiguredFeatures.createKey("huge_blue_aercloud_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERGROWN_CLOUD_MUSHROOM_TREES = DAConfiguredFeatures.createKey("overgrown_cloud_mushroom_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUNROOT_AND_CONBERRY_TREES_PLACEMENT = DAConfiguredFeatures.createKey("sunroot_and_conberry_trees_placement");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOTEM = DAConfiguredFeatures.createKey("totem");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_SQUASH = DAConfiguredFeatures.createKey("patch_squash");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERCLOUD_CLOUD = DAConfiguredFeatures.createKey("aercloud_cloud");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERCLOUD_CLOUD_OVERGROWN = DAConfiguredFeatures.createKey("aercloud_cloud_overgrown");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERCLOUD_RAIN_CLOUD = DAConfiguredFeatures.createKey("aercloud_rain_cloud");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMINESCENT_LARGE_SKYROOT_FOREST_TREE = DAConfiguredFeatures.createKey("luminescent_large_skyroot_forest_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMINESCENT_SMALL_SKYROOT_FOREST_TREE = DAConfiguredFeatures.createKey("luminescent_small_skyroot_forest_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMINESCENT_SKYROOT_FOREST_TREES = DAConfiguredFeatures.createKey("luminescent_skyroot_forest_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMINESCENT_SKYROOT_FOREST_GRASS = DAConfiguredFeatures.createKey("luminescent_skyroot_forest_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUMINESCENT_SKYROOT_FOREST_VEGETATION = DAConfiguredFeatures.createKey("luminescent_skyroot_forest_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERCLOUD_TREE_CONFIGURATION = DAConfiguredFeatures.createKey("aercloud_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERCLOUD_GRASS = DAConfiguredFeatures.createKey("aercloud_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERCLOUD_ROOTS_CARPET = DAConfiguredFeatures.createKey("aercloud_roots_carpet");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AERCLOUD_ROOTS = DAConfiguredFeatures.createKey("aercloud_roots");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWING_FLOWERS = DAConfiguredFeatures.createKey("glowing_flowers");
    public static final RuleTest RAIN_AERCLOUD = new TagMatchTest(DATags.Blocks.STERLING_AERCLOUD_REPLACEABLE);

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter holdergetter = context.lookup(Registries.BLOCK);
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        DAConfiguredFeatures.register(context, POISON_LAKE_CONFIGURATION, (Feature)DAFeatures.POISON_LAKE.get(), AetherConfiguredFeatureBuilders.lake((BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.POISON_BLOCK.get())), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.AETHER_MUD.get()))));
        DAConfiguredFeatures.register(context, POISON_SPRING_CONFIGURATION, Feature.SPRING, AetherConfiguredFeatureBuilders.spring((FluidState)((LiquidBlock)DABlocks.POISON_BLOCK.get()).fluid.defaultFluidState(), (boolean)true, (int)4, (int)1, (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{(Block)AetherBlocks.HOLYSTONE.get(), (Block)DABlocks.AETHER_MUD.get()})));
        DAConfiguredFeatures.register(context, AERCLOUD_LAKE_CONFIGURATION, (Feature)AetherFeatures.LAKE.get(), AetherConfiguredFeatureBuilders.lake((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.WATER), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.RAIN_AERCLOUD.get()))));
        FeatureUtils.register(context, HUGE_LIGHTCAP_MUSHROOM, (Feature)Feature.HUGE_RED_MUSHROOM, (FeatureConfiguration)new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)((Block)DABlocks.LIGHTCAP_MUSHROOM_BLOCK.get()).defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.TRUE)).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)Blocks.MUSHROOM_STEM.defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.FALSE)).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), 2));
        FeatureUtils.register(context, HUGE_PINK_AERCLOUD_MUSHROOM, (Feature)((Feature)DAFeatures.IMPROVED_MUSHROOM_FEATURE.get()), (FeatureConfiguration)new DAHugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)((Block)DABlocks.PINK_AERCLOUD_MUSHROOM_BLOCK.get()).defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.TRUE)).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AetherBlocks.COLD_AERCLOUD.get()).defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.AERCLOUD_ROOTS.get())), 3, 4, 3, 1));
        FeatureUtils.register(context, HUGE_BLUE_AERCLOUD_MUSHROOM, (Feature)((Feature)DAFeatures.IMPROVED_MUSHROOM_FEATURE.get()), (FeatureConfiguration)new DAHugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)((Block)DABlocks.BLUE_AERCLOUD_MUSHROOM_BLOCK.get()).defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.TRUE)).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.FALSE))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)AetherBlocks.COLD_AERCLOUD.get()).defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.AERCLOUD_ROOTS.get())), 2, 4, 7, 2));
        DAConfiguredFeatures.register(context, OVERGROWN_CLOUD_MUSHROOM_TREES, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(HUGE_PINK_AERCLOUD_MUSHROOM), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.BLUE_ROSEROOT_SAPLING.get()))}), 0.5f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(HUGE_BLUE_AERCLOUD_MUSHROOM), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.BLUE_ROSEROOT_SAPLING.get()))})));
        DAConfiguredFeatures.register(context, AERCLOUD_TREE_CONFIGURATION, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)AetherFeatureStates.SKYROOT_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.AERCLOUD_LEAVES), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build());
        DAConfiguredFeatures.register(context, LUMINESCENT_SMALL_SKYROOT_FOREST_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)AetherFeatureStates.SKYROOT_LOG), (TrunkPlacer)new StraightTrunkPlacer(7, 4, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)AetherFeatureStates.SKYROOT_LEAVES), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).decorators(List.of(GlowingTrunkVineDecorator.INSTANCE, new GlowingVineDecorator(0.25f))).ignoreVines().build());
        DAConfiguredFeatures.register(context, LUMINESCENT_LARGE_SKYROOT_FOREST_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)AetherFeatureStates.SKYROOT_LOG), (TrunkPlacer)new MegaJungleTrunkPlacer(10, 2, 19), (BlockStateProvider)BlockStateProvider.simple((BlockState)AetherFeatureStates.SKYROOT_LEAVES), (FoliagePlacer)new MegaJungleFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).decorators((List)ImmutableList.of((Object)((Object)GlowingTrunkVineDecorator.INSTANCE), (Object)((Object)new GlowingVineDecorator(0.25f)))).ignoreVines().build());
        DAConfiguredFeatures.register(context, LUMINESCENT_SKYROOT_FOREST_TREES, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(LUMINESCENT_LARGE_SKYROOT_FOREST_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)AetherBlocks.SKYROOT_SAPLING.get()))}), 0.15f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(LUMINESCENT_SMALL_SKYROOT_FOREST_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)AetherBlocks.SKYROOT_SAPLING.get()))})));
        DAConfiguredFeatures.register(context, LUMINESCENT_SKYROOT_FOREST_GRASS, Feature.RANDOM_PATCH, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.SHORT_GRASS.defaultBlockState(), 40).add((Object)((Block)DABlocks.TALL_GLOWING_GRASS.get()).defaultBlockState(), 20).add((Object)DAFeatureStates.RADIANT_ORCHID, 4)), (int)140));
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.add((Object)((BlockState)((BlockState)((Block)DABlocks.GLOWING_SPORES.get()).defaultBlockState().setValue((Property)PinkPetalsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)PinkPetalsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        DAConfiguredFeatures.register(context, GLOWING_FLOWERS, Feature.FLOWER, new RandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder)))));
        DAConfiguredFeatures.register(context, LUMINESCENT_SKYROOT_FOREST_VEGETATION, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(LUMINESCENT_SKYROOT_FOREST_GRASS), (PlacementModifier[])new PlacementModifier[0]), 0.5f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(GLOWING_FLOWERS), (PlacementModifier[])new PlacementModifier[0])));
        DAConfiguredFeatures.register(context, AERCLOUD_GRASS, Feature.RANDOM_PATCH, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)AetherFeatureStates.WHITE_FLOWER, 2).add((Object)AetherFeatureStates.PURPLE_FLOWER, 2).add((Object)DAFeatureStates.RADIANT_ORCHID, 2).add((Object)((Block)DABlocks.BLUE_AERCLOUD_MUSHROOMS.get()).defaultBlockState(), 2).add((Object)((Block)DABlocks.PINK_AERCLOUD_MUSHROOMS.get()).defaultBlockState(), 2)), (int)20));
        DAConfiguredFeatures.register(context, AERCLOUD_ROOTS_CARPET, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.AERCLOUD_ROOT_CARPET.get()))));
        DAConfiguredFeatures.register(context, ROSEROOT_TREE_LARGE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.ROSEROOT_LOG), (TrunkPlacer)new StraightTrunkPlacer(9, 10, 0), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.ROSEROOT_LEAVES, 4).add((Object)DAFeatureStates.FLOWERING_ROSEROOT_LEAVES, 1)), (FoliagePlacer)new RoserootFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.ZERO, (IntProvider)ConstantInt.of((int)1)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build());
        DAConfiguredFeatures.register(context, FALLEN_AERGLOW_TREE, (Feature)DAFeatures.FALLEN_TREE.get(), new FallenTreeConfiguration(2, 12, (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.ROSEROOT_LOG), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.LIGHTCAP_MUSHROOMS.get()))));
        DAConfiguredFeatures.register(context, EMPTY_FALLEN_AERGLOW_TREE, (Feature)DAFeatures.FALLEN_TREE.get(), new FallenTreeConfiguration(2, 9, (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.ROTTEN_ROSEROOT_LOG), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.LIGHTCAP_MUSHROOMS.get()))));
        DAConfiguredFeatures.register(context, ROSEROOT_TREE_SMALL, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.ROSEROOT_LOG), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 0), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.ROSEROOT_LEAVES, 4).add((Object)DAFeatureStates.FLOWERING_ROSEROOT_LEAVES, 1)), (FoliagePlacer)new RoserootFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.ZERO, (IntProvider)ConstantInt.of((int)1)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build());
        DAConfiguredFeatures.register(context, VIRULENT_QUICKSAND_PATCH, (Feature)AetherFeatures.SHELF.get(), new ShelfConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.VIRULENT_QUICKSAND), (FloatProvider)ConstantFloat.of((float)Mth.sqrt((float)12.0f)), UniformInt.of((int)0, (int)48), (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{(Block)DABlocks.AETHER_MUD.get()})));
        DAConfiguredFeatures.register(context, BLUE_ROSEROOT_TREE_LARGE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.ROSEROOT_LOG), (TrunkPlacer)new StraightTrunkPlacer(9, 10, 0), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.BLUE_ROSEROOT_LEAVES, 4).add((Object)DAFeatureStates.FLOWERING_BLUE_ROSEROOT_LEAVES, 1)), (FoliagePlacer)new RoserootFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.ZERO, (IntProvider)ConstantInt.of((int)1)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build());
        DAConfiguredFeatures.register(context, BLUE_ROSEROOT_TREE_SMALL, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.ROSEROOT_LOG), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 0), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.BLUE_ROSEROOT_LEAVES, 4).add((Object)DAFeatureStates.FLOWERING_BLUE_ROSEROOT_LEAVES, 1)), (FoliagePlacer)new RoserootFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.ZERO, (IntProvider)ConstantInt.of((int)1)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build());
        DAConfiguredFeatures.register(context, YAGROOT_TREE_CONFIGURATION, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.YAGROOT_LOG), (TrunkPlacer)new YagrootTrunkPlacer(4, 6, 2), (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.YAGROOT_LEAVES), (FoliagePlacer)new YagrootFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)1)), Optional.of(new YagrootRootPlacer((IntProvider)UniformInt.of((int)0, (int)1), (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.YAGROOT_ROOTS), Optional.of(new AboveRootPlacement((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.AETHER_MOSS_CARPET), 0.5f)), new MangroveRootPlacement((HolderSet)holdergetter.getOrThrow(BlockTags.MANGROVE_ROOTS_CAN_GROW_THROUGH), (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{(Block)DABlocks.AETHER_MUD.get(), (Block)DABlocks.MUDDY_YAGROOT_ROOTS.get()}), (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.YAGROOT_ROOTS), 8, 15, 0.0f))), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).decorators(List.of(new YagrootVineDecorator(0.2f))).ignoreVines().build());
        DAConfiguredFeatures.register(context, CRUDEROOT_TREE_CONFIGURATION, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.CRUDEROOT_LOG), (TrunkPlacer)new StraightTrunkPlacer(5, 7, 3), (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.CRUDEROOT_LEAVES), (FoliagePlacer)new RoserootFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.ZERO, (IntProvider)ConstantInt.of((int)1)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
        DAConfiguredFeatures.register(context, CONBERRY_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.CONBERRY_LOG), (TrunkPlacer)new TwinTrunkPlacer(7, 6, 3), (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.CONBERRY_LEAVES), (FoliagePlacer)new CherryFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)5), 0.25f, 0.5f, 0.16666667f, 0.33333334f), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
        DAConfiguredFeatures.register(context, SUNROOT_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.SUNROOT_LOG), (TrunkPlacer)new SunrootTunkPlacer(4, 6, 3), (BlockStateProvider)BlockStateProvider.simple((BlockState)DAFeatureStates.SUNROOT_LEAVES), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)2), 100), (FeatureSize)new TwoLayersFeatureSize(2, 1, 4)).decorators(List.of(new SunrootHangerDecorator(0.2f))).ignoreVines().build());
        DAConfiguredFeatures.register(context, GOLDEN_GRASS_PATCH, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)DABlocks.MINI_GOLDEN_GRASS.get()).defaultBlockState(), 32).add((Object)((Block)DABlocks.SHORT_GOLDEN_GRASS.get()).defaultBlockState(), 32).add((Object)((Block)DABlocks.MEDIUM_GOLDEN_GRASS.get()).defaultBlockState(), 16).add((Object)((Block)DABlocks.GOLDEN_FLOWER.get()).defaultBlockState(), 1).add((Object)((Block)DABlocks.ENCHANTED_BLOSSOM.get()).defaultBlockState(), 4).add((Object)((Block)DABlocks.TALL_GOLDEN_GRASS.get()).defaultBlockState(), 2)), (int)418));
        DAConfiguredFeatures.register(context, GOLDEN_GROVE_GRASS_PATCH, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)DABlocks.MINI_GOLDEN_GRASS.get()).defaultBlockState(), 16).add((Object)((Block)DABlocks.SHORT_GOLDEN_GRASS.get()).defaultBlockState(), 16).add((Object)((Block)DABlocks.MEDIUM_GOLDEN_GRASS.get()).defaultBlockState(), 48).add((Object)((Block)DABlocks.GOLDEN_FLOWER.get()).defaultBlockState(), 1).add((Object)((Block)DABlocks.ENCHANTED_BLOSSOM.get()).defaultBlockState(), 4).add((Object)((Block)DABlocks.TALL_GOLDEN_GRASS.get()).defaultBlockState(), 8)), (int)218));
        DAConfiguredFeatures.register(context, GOLDEN_GRASS_BLOCK_BONEMEAL_PATCH, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)DABlocks.MEDIUM_GOLDEN_GRASS.get()).defaultBlockState(), 1).add((Object)((Block)DABlocks.MINI_GOLDEN_GRASS.get()).defaultBlockState(), 1).add((Object)((Block)DABlocks.SHORT_GOLDEN_GRASS.get()).defaultBlockState(), 1).add((Object)((Block)DABlocks.TALL_GOLDEN_GRASS.get()).defaultBlockState(), 1))));
        DAConfiguredFeatures.register(context, GOLDEN_VINES_PATCH, Feature.RANDOM_PATCH, new RandomPatchConfiguration(1, 1, 0, PlacementUtils.inlinePlaced((Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)UniformInt.of((int)0, (int)1), 1).add((Object)UniformInt.of((int)0, (int)2), 4).add((Object)UniformInt.of((int)0, (int)3), 5).build()), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)DABlocks.GOLDEN_VINES_PLANT.get()).defaultBlockState(), 4).add((Object)((BlockState)((Block)DABlocks.GOLDEN_VINES_PLANT.get()).defaultBlockState().setValue((Property)GoldenVines.BERRIES, (Comparable)Boolean.TRUE)), 1))), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)DABlocks.GOLDEN_VINES.get()).defaultBlockState(), 4).add((Object)((BlockState)((Block)DABlocks.GOLDEN_VINES.get()).defaultBlockState().setValue((Property)CaveVines.BERRIES, (Comparable)Boolean.TRUE)), 1)), CaveVinesBlock.AGE, (IntProvider)UniformInt.of((int)23, (int)25)))), Direction.UP, BlockPredicate.ONLY_IN_AIR_PREDICATE, true), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)((Block)DABlocks.GOLDEN_VINES_PLANT.get()).defaultBlockState(), (Vec3i)BlockPos.ZERO), (BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{(Block)DABlocks.GOLDEN_VINES.get()}))))})));
        DAConfiguredFeatures.register(context, AERLAVENDER_PATCH, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.AERLAVENDER, 64).add((Object)DAFeatureStates.TALL_AERLAVENDER, 32).add((Object)Blocks.TALL_GRASS.defaultBlockState(), 16).add((Object)AetherFeatureStates.BERRY_BUSH, 1).add((Object)Blocks.SHORT_GRASS.defaultBlockState(), 32)), (int)418));
        DAConfiguredFeatures.register(context, AETHER_CATTAILS_PATCH, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.AETHER_CATTAILS, 5).add((Object)Blocks.SHORT_GRASS.defaultBlockState(), 5).add((Object)DAFeatureStates.TALL_AETHER_CATTAILS, 3)), (int)15));
        DAConfiguredFeatures.register(context, ROSEROOT_FOREST_FLOWERS, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.RADIANT_ORCHID, 8).add((Object)DAFeatureStates.IASPOVE, 4)), (int)50));
        DAConfiguredFeatures.register(context, MYSTIC_ROSEROOT_FOREST_FLOWERS, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.RADIANT_ORCHID, 4).add((Object)DAFeatureStates.SKY_TULIPS, 1).add((Object)DAFeatureStates.IASPOVE, 1).add((Object)DAFeatureStates.GOLDEN_ASPESS, 1).add((Object)DAFeatureStates.ECHAISY, 1)), (int)50));
        DAConfiguredFeatures.register(context, SKY_TULIPS, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.SKY_TULIPS, 1)), (int)20));
        DAConfiguredFeatures.register(context, GOLDEN_ASPESS, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.GOLDEN_ASPESS, 1)), (int)20));
        DAConfiguredFeatures.register(context, ECHAISY, Feature.FLOWER, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.ECHAISY, 1)), (int)20));
        DAConfiguredFeatures.register(context, PATCH_SQUASH, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)DABlocks.BLUE_SQUASH.get()).defaultBlockState(), 1).add((Object)((Block)DABlocks.GREEN_SQUASH.get()).defaultBlockState(), 1))), List.of((Block)AetherBlocks.AETHER_GRASS_BLOCK.get())));
        DAConfiguredFeatures.register(context, ROSEROOT_FOREST_GRASS, Feature.RANDOM_PATCH, NitrogenConfiguredFeatureBuilders.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)DAFeatureStates.FEATHER_GRASS, 12).add((Object)DAFeatureStates.TALL_FEATHER_GRASS, 3).add((Object)Blocks.SHORT_GRASS.defaultBlockState(), 6).add((Object)Blocks.TALL_GRASS.defaultBlockState(), 2).add((Object)AetherFeatureStates.BERRY_BUSH, 1)), (int)90));
        DAConfiguredFeatures.register(context, ROSEROOT_TREES_PLACEMENT, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(HUGE_LIGHTCAP_MUSHROOM), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.ROSEROOT_SAPLING.get()))}), 0.01f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(ROSEROOT_TREE_LARGE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.ROSEROOT_SAPLING.get()))}), 0.33f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(ROSEROOT_TREE_SMALL), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.ROSEROOT_SAPLING.get()))})));
        DAConfiguredFeatures.register(context, BLUE_ROSEROOT_TREES_PLACEMENT, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BLUE_ROSEROOT_TREE_LARGE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.BLUE_ROSEROOT_SAPLING.get()))}), 0.33f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BLUE_ROSEROOT_TREE_SMALL), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.BLUE_ROSEROOT_SAPLING.get()))})));
        DAConfiguredFeatures.register(context, ROSEROOT_AND_BLUE_ROSEROOT_TREES_PLACEMENT, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BLUE_ROSEROOT_TREES_PLACEMENT), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.BLUE_ROSEROOT_SAPLING.get()))}), 0.15f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(ROSEROOT_TREES_PLACEMENT), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.BLUE_ROSEROOT_SAPLING.get()))})));
        DAConfiguredFeatures.register(context, YAGROOT_AND_CRUDEROOT_TREES_PLACEMENT, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(CRUDEROOT_TREE_CONFIGURATION), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.CRUDEROOT_SAPLING.get()))}), 0.25f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(YAGROOT_TREE_CONFIGURATION), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.YAGROOT_SAPLING.get()))})));
        DAConfiguredFeatures.register(context, SUNROOT_AND_CONBERRY_TREES_PLACEMENT, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(SUNROOT_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.SUNROOT_SAPLING.get()))}), 0.5f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(CONBERRY_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)DABlocks.CONBERRY_SAPLING.get()))})));
        DAConfiguredFeatures.register(context, AETHER_MOSS_VEGETATION, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)DABlocks.AETHER_MOSS_CARPET.get()).defaultBlockState(), 25).add((Object)Blocks.SHORT_GRASS.defaultBlockState(), 50).add((Object)Blocks.SHORT_GRASS.defaultBlockState(), 10))));
        DAConfiguredFeatures.register(context, AETHER_MOSS_PATCH_BONEMEAL, Feature.VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.AETHER_MOSS_BLOCK.get())), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(AETHER_MOSS_VEGETATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.6f, (IntProvider)UniformInt.of((int)1, (int)2), 0.75f));
        DAConfiguredFeatures.register(context, AETHER_COARSE_DIRT, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)DABlocks.LIGHTCAP_MUSHROOMS.get()).defaultBlockState(), 1).add((Object)Blocks.AIR.defaultBlockState(), 10))));
        DAConfiguredFeatures.register(context, AETHER_COARSE_DIRT_PATCH, Feature.VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)DABlocks.AETHER_COARSE_DIRT.get())), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(AETHER_COARSE_DIRT), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.6f, (IntProvider)UniformInt.of((int)1, (int)2), 0.75f));
        DAConfiguredFeatures.register(context, ORE_SKYJADE_CONFIGURATION, Feature.ORE, new OreConfiguration(AetherFeatureRules.HOLYSTONE, DAFeatureStates.SKYJADE_ORE, 6, 0.65f));
        DAConfiguredFeatures.register(context, ORE_MORE_SKYJADE_CONFIGURATION, Feature.ORE, new OreConfiguration(AetherFeatureRules.HOLYSTONE, DAFeatureStates.SKYJADE_ORE, 16, 0.0f));
        DAConfiguredFeatures.register(context, ASETERITE_CONFIGURATION, Feature.ORE, new OreConfiguration(AetherFeatureRules.HOLYSTONE, DAFeatureStates.ASETERITE, 64));
        DAConfiguredFeatures.register(context, CLORITE_CONFIGURATION, Feature.ORE, new OreConfiguration(AetherFeatureRules.HOLYSTONE, DAFeatureStates.RAW_CLORITE, 64));
        DAConfiguredFeatures.register(context, STERLING_AERCLOUD_CONFIGURATION, (Feature)AetherFeatures.AERCLOUD.get(), new AercloudConfiguration(2, (BlockStateProvider)SimpleStateProvider.simple((Block)((Block)DABlocks.STERLING_AERCLOUD.get()))));
        DAConfiguredFeatures.register(context, AERCLOUD_CLOUD, (Feature)DAFeatures.AERCLOUD_CLOUD.get(), new AercloudCloudConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)AetherFeatureStates.COLD_AERCLOUD, 10000).add((Object)((Block)DABlocks.STERLING_AERCLOUD.get()).defaultBlockState(), 1)), Boolean.FALSE));
        DAConfiguredFeatures.register(context, AERCLOUD_CLOUD_OVERGROWN, (Feature)DAFeatures.AERCLOUD_CLOUD.get(), new AercloudCloudConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)AetherFeatureStates.COLD_AERCLOUD, 1).add((Object)((Block)DABlocks.STERLING_AERCLOUD.get()).defaultBlockState(), 1)), Boolean.TRUE));
        DAConfiguredFeatures.register(context, AERCLOUD_RAIN_CLOUD, (Feature)DAFeatures.RAIN_AERCLOUD_CLOUD.get(), new AercloudCloudConfiguration((BlockStateProvider)SimpleStateProvider.simple((Block)((Block)DABlocks.RAIN_AERCLOUD.get())), Boolean.FALSE));
        DAConfiguredFeatures.register(context, AERCLOUD_ROOTS, (RootFeature)((Object)DAFeatures.AERCLOUD_ROOTS.get()), new AercloudConfiguration(20, (BlockStateProvider)SimpleStateProvider.simple((Block)((Block)AetherBlocks.COLD_AERCLOUD.get()))));
        DAConfiguredFeatures.register(context, TOTEM, (Feature)DAFeatures.TOTEM.get(), NoneFeatureConfiguration.INSTANCE);
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static BlockStateProvider prov(BlockState state) {
        return BlockStateProvider.simple((BlockState)DAConfiguredFeatures.drops(state));
    }

    private static BlockStateProvider prov(DeferredBlock<? extends Block> block) {
        return DAConfiguredFeatures.prov(((Block)block.get()).defaultBlockState());
    }

    private static BlockState drops(BlockState state) {
        return state.hasProperty((Property)AetherBlockStateProperties.DOUBLE_DROPS) ? (BlockState)state.setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)) : state;
    }

    private static BlockState drops(DeferredBlock<? extends Block> block) {
        return DAConfiguredFeatures.drops(((Block)block.get()).defaultBlockState());
    }
}

