/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.renderer.accessory;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.razordevs.deep_aether.client.renderer.DAModelLayers;
import io.github.razordevs.deep_aether.item.dungeon.brass.WindShieldItem;
import io.github.razordevs.deep_aether.networking.attachment.DAAttachments;
import io.github.razordevs.deep_aether.networking.attachment.DAPlayerAttachment;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class WindShieldRenderer
implements AccessoryRenderer {
    private final HumanoidModel<LivingEntity> shieldModel = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(DAModelLayers.WIND_SHIELD));
    public final HumanoidModel<LivingEntity> shieldModelArm = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(DAModelLayers.WIND_SHIELD_ARM));

    public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack poseStack, EntityModel<M> entityModel, MultiBufferSource buffer, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Player player;
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof Player && ((DAPlayerAttachment)(player = (Player)livingEntity).getData(DAAttachments.PLAYER)).getWindShieldCooldown() > 0) {
            return;
        }
        WindShieldItem shield = (WindShieldItem)stack.getItem();
        ResourceLocation texture = shield.getWindShieldTexture();
        HumanoidModel<LivingEntity> model = this.shieldModel;
        entityModel.copyPropertiesTo(model);
        AccessoryRenderer.followBodyRotations((LivingEntity)reference.entity(), model);
        float f = (float)livingEntity.tickCount + partialTicks;
        VertexConsumer consumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)WindShieldRenderer.windShieldRenderType(texture, f * 0.02f % 1.0f, 0.0f), (boolean)false);
        model.renderToBuffer(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
    }

    public boolean shouldRenderInFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference) {
        Player player;
        LivingEntity livingEntity = reference.entity();
        return !(livingEntity instanceof Player) || !((AetherPlayerAttachment)(player = (Player)livingEntity).getData((Supplier)AetherDataAttachments.AETHER_PLAYER)).isWearingInvisibilityCloak();
    }

    public <M extends LivingEntity> void renderOnFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light) {
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            this.renderFirstPerson(stack, matrices, multiBufferSource, light, player, arm);
        }
    }

    public void renderFirstPerson(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, HumanoidArm arm) {
        if (((DAPlayerAttachment)player.getData(DAAttachments.PLAYER)).getWindShieldCooldown() > 0) {
            return;
        }
        boolean isSlim = player.getSkin().model() == PlayerSkin.Model.SLIM;
        this.setupShieldOnHand(stack, this.shieldModelArm, poseStack, buffer, packedLight, player, arm, isSlim);
    }

    private void setupShieldOnHand(ItemStack stack, HumanoidModel<LivingEntity> model, PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, HumanoidArm arm, boolean isSlim) {
        this.setupModel(model, player);
        WindShieldItem shield = (WindShieldItem)stack.getItem();
        VertexConsumer consumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.breezeWind((ResourceLocation)shield.getWindShieldTexture(), (float)((float)player.tickCount * 0.02f % 1.0f), (float)0.0f), (boolean)false);
        boolean flag = arm != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float offset = 0.0375f;
        if (isSlim) {
            offset = 0.0425f;
        }
        poseStack.translate((double)(f * offset) - 0.0025, 0.0025, -0.0025);
        if (arm == HumanoidArm.RIGHT) {
            this.renderShieldOnHand(model.rightArm, poseStack, packedLight, consumer);
        } else if (arm == HumanoidArm.LEFT) {
            this.renderShieldOnHand(model.leftArm, poseStack, packedLight, consumer);
        }
    }

    private void setupModel(HumanoidModel<LivingEntity> model, AbstractClientPlayer player) {
        model.setAllVisible(false);
        model.attackTime = 0.0f;
        model.crouching = false;
        model.swimAmount = 0.0f;
        model.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private void renderShieldOnHand(ModelPart shieldArm, PoseStack poseStack, int packedLight, VertexConsumer consumer) {
        shieldArm.visible = true;
        shieldArm.xRot = 0.0f;
        shieldArm.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
    }

    public static RenderType windShieldRenderType(ResourceLocation location, float x, float y) {
        return RenderType.create((String)"deep_aether:wind_shield", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_BREEZE_WIND_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).setTexturingState((RenderStateShard.TexturingStateShard)new RenderStateShard.OffsetTexturingStateShard(x, y)).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setCullState(RenderType.NO_CULL).setDepthTestState(RenderType.LEQUAL_DEPTH_TEST).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).createCompositeState(false));
    }
}

