/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.renderer.accessory;

import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.accessory.GlovesRenderer;
import com.aetherteam.aether.client.renderer.accessory.model.GlovesModel;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import com.aetherteam.aether.mixin.mixins.client.accessor.PlayerModelAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.razordevs.deep_aether.networking.attachment.DAAttachments;
import io.github.razordevs.deep_aether.networking.attachment.DAPlayerAttachment;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;

public class SkyjadeGlovesRenderer
extends GlovesRenderer {
    private final GlovesModel glovesModel = new GlovesModel(Minecraft.getInstance().getEntityModels().bakeLayer(AetherModelLayers.GLOVES));
    private final GlovesModel glovesTrimModel = new GlovesModel(Minecraft.getInstance().getEntityModels().bakeLayer(AetherModelLayers.GLOVES_TRIM));
    private final GlovesModel glovesModelSlim = new GlovesModel(Minecraft.getInstance().getEntityModels().bakeLayer(AetherModelLayers.GLOVES_SLIM));
    private final GlovesModel glovesTrimModelSlim = new GlovesModel(Minecraft.getInstance().getEntityModels().bakeLayer(AetherModelLayers.GLOVES_TRIM_SLIM));
    private final GlovesModel glovesFirstPerson = new GlovesModel(Minecraft.getInstance().getEntityModels().bakeLayer(AetherModelLayers.GLOVES_FIRST_PERSON));
    private final GlovesModel glovesTrimFirstPerson = new GlovesModel(Minecraft.getInstance().getEntityModels().bakeLayer(AetherModelLayers.GLOVES_TRIM_FIRST_PERSON));
    private final TextureAtlas armorTrimAtlas = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);

    public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack poseStack, EntityModel<M> entityModel, MultiBufferSource buffer, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DAPlayerAttachment attachment;
        LivingEntity livingEntity = reference.entity();
        GlovesItem glovesItem = (GlovesItem)stack.getItem();
        GlovesModel model = this.glovesModel;
        GlovesModel trimModel = this.glovesTrimModel;
        ResourceLocation texture = glovesItem.getGlovesTexture();
        if (entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            PlayerModelAccessor playerModelAccessor = (PlayerModelAccessor)playerModel;
            model = playerModelAccessor.aether$getSlim() ? this.glovesModelSlim : this.glovesModel;
            trimModel = playerModelAccessor.aether$getSlim() ? this.glovesTrimModelSlim : this.glovesTrimModel;
        }
        AccessoryRenderer.followBodyRotations((LivingEntity)reference.entity(), (HumanoidModel)model);
        AccessoryRenderer.followBodyRotations((LivingEntity)reference.entity(), (HumanoidModel)trimModel);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)texture));
        int color = -1;
        if (livingEntity.hasData(DAAttachments.PLAYER) && (attachment = (DAPlayerAttachment)livingEntity.getData(DAAttachments.PLAYER)).isSkyjadeAbilityActivated() && attachment.hasSkyjadeSet()) {
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture));
            color = FastColor.ARGB32.color((int)60, (int)color);
        }
        model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        GlovesModel finalTrimModel = trimModel;
        ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
        if (trim != null) {
            TextureAtlasSprite textureAtlasSprite = this.armorTrimAtlas.getSprite(trim.outerTexture(glovesItem.getMaterial()));
            VertexConsumer trimConsumer = textureAtlasSprite.wrap(buffer.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
            finalTrimModel.renderToBuffer(poseStack, trimConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        }
        if (stack.hasFoil()) {
            model.renderToBuffer(poseStack, buffer.getBuffer(RenderType.armorEntityGlint()), packedLight, OverlayTexture.NO_OVERLAY, color);
        }
    }

    public void renderFirstPerson(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, HumanoidModel<?> humanoidModel, HumanoidArm arm) {
        DAPlayerAttachment attachment;
        GlovesModel model = this.glovesFirstPerson;
        GlovesModel trimModel = this.glovesTrimFirstPerson;
        GlovesItem glovesItem = (GlovesItem)stack.getItem();
        int color = -1;
        model.setAllVisible(false);
        model.attackTime = 0.0f;
        model.crouching = false;
        model.swimAmount = 0.0f;
        model.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        ModelPart gloveArm = arm == HumanoidArm.RIGHT ? model.rightArm : model.leftArm;
        gloveArm.visible = true;
        gloveArm.xRot = 0.0f;
        VertexConsumer consumer = buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)glovesItem.getGlovesTexture()));
        if (player.hasData(DAAttachments.PLAYER) && (attachment = (DAPlayerAttachment)player.getData(DAAttachments.PLAYER)).isSkyjadeAbilityActivated() && attachment.hasSkyjadeSet()) {
            consumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)glovesItem.getGlovesTexture()));
            color = FastColor.ARGB32.color((int)60, (int)color);
        }
        gloveArm.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
        if (trim != null) {
            trimModel.setAllVisible(false);
            trimModel.attackTime = 0.0f;
            trimModel.crouching = false;
            trimModel.swimAmount = 0.0f;
            trimModel.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            ModelPart gloveTrimArm = arm == HumanoidArm.RIGHT ? trimModel.rightArm : trimModel.leftArm;
            gloveTrimArm.visible = true;
            gloveTrimArm.xRot = 0.0f;
            TextureAtlasSprite textureAtlasSprite = this.armorTrimAtlas.getSprite(trim.outerTexture(glovesItem.getMaterial()));
            VertexConsumer trimConsumer = textureAtlasSprite.wrap(buffer.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
            gloveTrimArm.render(poseStack, trimConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
        if (stack.hasFoil()) {
            gloveArm.render(poseStack, buffer.getBuffer(RenderType.armorEntityGlint()), packedLight, OverlayTexture.NO_OVERLAY);
        }
    }
}

