/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeChecker {
    private Set<BiomeCombo> comboList = new HashSet<BiomeCombo>();
    private Set<ResourceLocation> whitelist;
    private Set<ResourceLocation> blacklist;

    public BiomeChecker(ConfigHandler.BiomeConfig biomeConfig) {
        for (String biomeComboString : (List)biomeConfig.biomeTags.get()) {
            BiomeCombo biomeCombo = new BiomeCombo(biomeComboString);
            this.comboList.add(biomeCombo);
        }
        this.whitelist = new HashSet<ResourceLocation>();
        for (String biomeString : (List)biomeConfig.biomeWhitelist.get()) {
            this.whitelist.add(ResourceLocation.tryParse((String)biomeString));
        }
        this.blacklist = new HashSet<ResourceLocation>();
        for (String biomeString : (List)biomeConfig.biomeBlacklist.get()) {
            this.blacklist.add(ResourceLocation.tryParse((String)biomeString));
        }
    }

    public boolean isBiomeInConfig(Holder<Biome> biome) {
        TagKey tagKey;
        for (ResourceLocation biomeName : this.whitelist) {
            tagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeName);
            if (biome.is(tagKey)) {
                return true;
            }
            if (!biome.is(biomeName)) continue;
            return true;
        }
        for (ResourceLocation biomeName : this.blacklist) {
            tagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeName);
            if (biome.is(tagKey)) {
                return false;
            }
            if (!biome.is(biomeName)) continue;
            return false;
        }
        for (BiomeCombo biomeCombo : this.comboList) {
            if (!biomeCombo.acceptsBiome(biome)) continue;
            return true;
        }
        return false;
    }

    private static class BiomeCombo {
        ResourceLocation[] neededTags;
        boolean[] inverted;

        private BiomeCombo(String biomeComboString) {
            String[] typeStrings = biomeComboString.replace(" ", "").split(",");
            this.neededTags = new ResourceLocation[typeStrings.length];
            this.inverted = new boolean[typeStrings.length];
            for (int i = 0; i < typeStrings.length; ++i) {
                if (typeStrings[i].length() == 0) continue;
                this.inverted[i] = typeStrings[i].charAt(0) == '!';
                String name = typeStrings[i].replace("!", "");
                this.neededTags[i] = ResourceLocation.tryParse((String)name);
            }
        }

        private boolean acceptsBiome(Holder<Biome> biome) {
            for (int i = 0; i < this.neededTags.length; ++i) {
                ResourceLocation neededBiomeName = this.neededTags[i];
                if (neededBiomeName == null) continue;
                TagKey neededBiomeTag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)neededBiomeName);
                boolean failIfMatches = this.inverted[i];
                if (!(failIfMatches ? biome.is(neededBiomeTag) || biome.is(neededBiomeName) : !biome.is(neededBiomeTag) && !biome.is(neededBiomeName))) continue;
                return false;
            }
            return true;
        }
    }
}

