/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MessageUseAbility(int entityId, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageUseAbility> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"message_use_ability"));
    public static final StreamCodec<ByteBuf, MessageUseAbility> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageUseAbility::entityId, (StreamCodec)ByteBufCodecs.INT, MessageUseAbility::index, MessageUseAbility::new);

    public static void handleClient(MessageUseAbility packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp;
            Level level = MMCommon.PROXY.getClientLevel();
            if (level != null && (patt0$temp = level.getEntity(packet.entityId())) instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)patt0$temp;
                AbilityData data = DataHandler.getData((Entity)entity, DataHandler.ABILITY_DATA);
                data.activateAbility(entity, data.getAbilityTypesOnEntity(entity)[packet.index()]);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

