/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerSculptorTrade;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MessageSculptorTrade(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageSculptorTrade> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"message_sculptor_trade"));
    public static final StreamCodec<ByteBuf, MessageSculptorTrade> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageSculptorTrade::entityId, MessageSculptorTrade::new);

    public static void handleServer(MessageSculptorTrade packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Entity patt0$temp = player.level().getEntity(packet.entityId());
            if (!(patt0$temp instanceof EntitySculptor)) {
                return;
            }
            EntitySculptor sculptor = (EntitySculptor)patt0$temp;
            if (sculptor.getCustomer() != player) {
                return;
            }
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (!(patt1$temp instanceof ContainerSculptorTrade)) {
                return;
            }
            ContainerSculptorTrade trade = (ContainerSculptorTrade)patt1$temp;
            if (sculptor.checkTestObstructed()) {
                return;
            }
            boolean satisfied = sculptor.fulfillDesire(trade.getSlot(0));
            if (satisfied) {
                trade.returnItems();
                trade.broadcastChanges();
                sculptor.setTestingPlayer(player);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

