/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.client.render.item.RenderSculptorStaff;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import java.util.List;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemSculptorStaff
extends DiggerItem
implements GeoItem {
    public static final String CONTROLLER_NAME = "controller";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation DISAPPEAR_ANIM = RawAnimation.begin().thenPlayAndHold("disappear");
    public static final String DISAPPEAR_ANIM_NAME = "disappear";

    public ItemSculptorStaff(Item.Properties properties) {
        super((Tier)Tiers.STONE, BlockTags.MINEABLE_WITH_HOE, properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean isValidRepairItem(ItemStack tool, ItemStack ingredient) {
        return ingredient.is((Item)ItemHandler.BLUFF_ROD.get());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.ROCK_SLING);
        player.startUsingItem(hand);
        if (!player.getAbilities().instabuild) {
            player.getItemInHand(hand).hurtAndBreak(2, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, CONTROLLER_NAME, 0, state -> PlayState.STOP).triggerableAnim(DISAPPEAR_ANIM_NAME, DISAPPEAR_ANIM));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class ClientExtensions
    implements IClientItemExtensions {
        private final BlockEntityWithoutLevelRenderer renderer = new RenderSculptorStaff();

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return this.renderer;
        }
    }
}

