/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.grottol.EntityGrottol;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class ItemCapturedGrottol
extends Item {
    public ItemCapturedGrottol(Item.Properties properties) {
        super(properties);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack;
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        if (context.getClickedFace() == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        BlockPos location = pos.relative(facing);
        if (!player.mayUseItemAt(location, facing, stack = player.getItemInHand(hand))) {
            return InteractionResult.FAIL;
        }
        if (!world.isClientSide) {
            EntityGrottol grottol = new EntityGrottol((EntityType<? extends EntityGrottol>)((EntityType)EntityHandler.GROTTOL.get()), world);
            CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (data != null) {
                this.setData(grottol, data.copyTag().getCompound("EntityTag"));
            }
            grottol.moveTo(location, 0.0f, 0.0f);
            this.lookAtPlayer(grottol, player);
            grottol.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(location), MobSpawnType.MOB_SUMMONED, null);
            world.addFreshEntity((Entity)grottol);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void setData(EntityGrottol grottol, CompoundTag compound) {
        CompoundTag data = grottol.serializeNBT((HolderLookup.Provider)grottol.registryAccess());
        UUID id = grottol.getUUID();
        data.merge(compound);
        grottol.deserializeNBT((HolderLookup.Provider)grottol.registryAccess(), data);
        grottol.setUUID(id);
    }

    private void lookAtPlayer(EntityGrottol grottol, Player player) {
        LookControl helper = new LookControl((Mob)grottol);
        helper.setLookAt((Entity)player, 180.0f, 90.0f);
        helper.tick();
    }

    public ItemStack create(EntityGrottol grottol) {
        ItemStack stack = new ItemStack((ItemLike)this);
        ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).update(tag -> tag.put("EntityTag", (Tag)grottol.serializeNBT((HolderLookup.Provider)grottol.registryAccess())));
        return stack;
    }
}

