/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.grottol;

import com.bobmowzie.mowziesmobs.server.entity.grottol.BlackPinkInYourArea;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;

public final class BlackPinkRailLine
implements Consumer<AbstractMinecart> {
    private final BlackPinkInYourArea action;
    private State state = new StateAcquireVertex();

    private BlackPinkRailLine(BlackPinkInYourArea action) {
        this.action = action;
    }

    @Override
    public void accept(AbstractMinecart minecart) {
        this.state = this.next(minecart.level(), minecart);
    }

    private State next(Level world, AbstractMinecart minecart) {
        BlockPos pos = BlackPinkRailLine.getRailPosition(world, BlockPos.containing((Position)minecart.position()));
        if (BaseRailBlock.isRail((BlockState)world.getBlockState(pos))) {
            return this.state.apply(world, minecart, pos);
        }
        return this.state.derail();
    }

    private static BlockPos getRailPosition(Level world, BlockPos pos) {
        BlockPos below = pos.below();
        return BaseRailBlock.isRail((Level)world, (BlockPos)below) ? below : pos;
    }

    public static BlackPinkRailLine create() {
        return new BlackPinkRailLine(BlackPinkInYourArea.create());
    }

    private final class StateAcquireVertex
    extends State {
        private StateAcquireVertex() {
            super(BlackPinkRailLine.this);
        }

        @Override
        public State apply(Level world, AbstractMinecart minecart, BlockPos vertex) {
            return new StateAcquireEdge(vertex);
        }

        @Override
        State derail() {
            return this;
        }
    }

    private abstract class State {
        private State(BlackPinkRailLine blackPinkRailLine) {
        }

        abstract State apply(Level var1, AbstractMinecart var2, BlockPos var3);

        abstract State derail();
    }

    private final class StateSearch
    extends State {
        private final long[] mask;
        private final long test = 0x10000000000000L;
        private Vec3i edge;
        private BlockPos vertex;
        private int ordinal;
        private long state;

        private StateSearch(Vec3i edge, BlockPos vertex) {
            super(BlackPinkRailLine.this);
            this.mask = new long[]{1151706154984090261L, 1149919144941647226L, 1152921487426969583L, 1152635631447310335L};
            this.test = 0x10000000000000L;
            this.state = 0xFFFFFFFFFFFFEL;
            this.edge = edge;
            this.vertex = vertex;
        }

        @Override
        public State apply(Level world, AbstractMinecart minecart, BlockPos vertex) {
            if (!this.vertex.equals((Object)vertex)) {
                BlockPos edge = vertex.subtract((Vec3i)this.vertex);
                int ordinal = this.getOrdinal(this.edge, (Vec3i)edge);
                if (ordinal >= 0 && ordinal < 4 && (ordinal != 1 || ordinal != this.ordinal) && ((this.state = (this.state | this.mask[ordinal]) << 1) & 0x10000000000000L) == 0L) {
                    BlackPinkRailLine.this.action.accept(world, minecart);
                }
                this.ordinal = ordinal;
                this.vertex = vertex;
                this.edge = edge;
            }
            return this;
        }

        private int getOrdinal(Vec3i v0, Vec3i v1) {
            return 1 + (v1.getZ() * v0.getX() - v1.getX() * v0.getZ()) + (v0.getX() * v1.getX() + v0.getZ() * v1.getZ() & 2);
        }

        @Override
        State derail() {
            return new StateAcquireVertex();
        }
    }

    private final class StateAcquireEdge
    extends State {
        private final BlockPos vertex;

        private StateAcquireEdge(BlockPos vertex) {
            super(BlackPinkRailLine.this);
            this.vertex = vertex;
        }

        @Override
        public State apply(Level world, AbstractMinecart minecart, BlockPos vertex) {
            return new StateSearch((Vec3i)vertex.subtract((Vec3i)this.vertex), vertex);
        }

        @Override
        State derail() {
            return new StateAcquireVertex();
        }
    }
}

