/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.RibbonComponent;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.damage.DamageUtil;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntitySuperNova
extends EntityMagicEffect {
    public static int DURATION = 40;

    public EntitySuperNova(EntityType<? extends EntitySuperNova> type, Level world) {
        super(type, world);
    }

    public EntitySuperNova(EntityType<? extends EntitySuperNova> type, Level world, LivingEntity caster, double x, double y, double z) {
        super(type, world, caster);
        this.setPos(x, y, z);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getCaster() == null || this.getCaster().isRemoved() || !this.getCaster().isAlive()) {
            this.discard();
        }
        if (this.tickCount == 1) {
            EntityCameraShake.cameraShake(this.level(), this.position(), 30.0f, 0.05f, 10, 30);
            this.playSound((SoundEvent)MMSounds.ENTITY_SUPERNOVA_END.get(), 3.0f, 1.0f);
            if (this.level().isClientSide) {
                float scale = 8.2f;
                for (int i = 0; i < 15; ++i) {
                    float phaseOffset = this.random.nextFloat();
                    AdvancedParticleBase.spawnParticle(this.level(), ParticleHandler.ARROW_HEAD, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 8.0, 0.95, 0.9, 0.35, 1.0, 1.0, 30.0, true, true, new ParticleComponent[]{new ParticleComponent.Orbit(new Vec3[]{this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0)}, ParticleComponent.KeyTrack.startAndEnd(0.0f + phaseOffset, 1.6f + phaseOffset), new ParticleComponent.KeyTrack(new float[]{0.2f * scale, 0.63f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, 1.0f * scale}, new float[]{0.0f, 0.15f, 0.3f, 0.45f, 0.6f, 0.75f}), ParticleComponent.KeyTrack.startAndEnd(this.random.nextFloat() * 2.0f - 1.0f, this.random.nextFloat() * 2.0f - 1.0f), ParticleComponent.KeyTrack.startAndEnd(this.random.nextFloat() * 2.0f - 1.0f, this.random.nextFloat() * 2.0f - 1.0f), ParticleComponent.KeyTrack.startAndEnd(this.random.nextFloat() * 2.0f - 1.0f, this.random.nextFloat() * 2.0f - 1.0f), false), new RibbonComponent((Holder<ParticleType<?>>)ParticleHandler.RIBBON_FLAT, 10, 0.0, 0.0, 0.0, 0.2f, 0.95, 0.9, 0.35, 1.0, true, true, new ParticleComponent[]{new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f)), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)}), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.FaceMotion()});
                }
            }
        }
        if (this.getCaster() != null) {
            float ageFrac = (float)this.tickCount / (float)DURATION;
            float scale = (float)Math.pow(ageFrac, 0.5) * 5.0f;
            this.setBoundingBox(this.getBoundingBox().inflate((double)scale));
            this.setPos(this.xo, this.yo, this.zo);
            List<Entity> hitList = this.getEntitiesNearbyCube(Entity.class, scale);
            for (Entity entity : hitList) {
                if (entity instanceof ItemEntity || this.getCaster() == entity || entity instanceof ItemEntity || this.getCaster() instanceof EntityUmvuthi && entity instanceof LeaderSunstrikeImmune) continue;
                if (entity instanceof LivingEntity) {
                    boolean hitWithFire;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (!this.getCaster().canAttack(livingEntity)) continue;
                    float damageFire = 4.0f;
                    float damageMob = 4.0f;
                    if (this.getCaster() instanceof EntityUmvuthi) {
                        damageFire = (float)((double)damageFire * (Double)ConfigHandler.COMMON.MOBS.UMVUTHI.combatConfig.attackMultiplier.get());
                        damageMob = (float)((double)damageMob * (Double)ConfigHandler.COMMON.MOBS.UMVUTHI.combatConfig.attackMultiplier.get());
                    }
                    if (this.getCaster() instanceof Player) {
                        damageFire = (float)((double)damageFire * ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.sunsBlessingAttackMultiplier.get() * 0.8));
                        damageMob = (float)((double)damageMob * ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.sunsBlessingAttackMultiplier.get() * 0.8));
                    }
                    if (!(hitWithFire = ((Boolean)DamageUtil.dealMixedDamage(livingEntity, this.damageSources().mobProjectile((Entity)this, this.getCaster()), damageMob, this.damageSources().onFire(), damageFire).getRight()).booleanValue())) continue;
                    Vec3 diff = livingEntity.position().subtract(this.position());
                    diff = diff.normalize();
                    livingEntity.knockback((double)0.4f, -diff.x, -diff.z);
                    livingEntity.igniteForSeconds(5.0f);
                    continue;
                }
                entity.hurt(this.damageSources().mobProjectile((Entity)this, this.getCaster()), 4.0f);
            }
        }
        if (this.tickCount > DURATION) {
            this.discard();
        }
    }

    public float getLightLevelDependentMagicValue() {
        return 1.572888E7f;
    }
}

